/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.etiao.mbeans;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.edgent.execution.Job;
import org.apache.edgent.execution.mbeans.JobMXBean;
import org.apache.edgent.execution.services.ControlService;
import org.apache.edgent.graph.Graph;
import org.apache.edgent.runtime.etiao.EtiaoJob;
import org.apache.edgent.runtime.etiao.graph.model.GraphType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtiaoJobBean
implements JobMXBean {
    private final EtiaoJob job;
    private ControlService controlService;
    private String controlId;
    private static final Logger logger = LoggerFactory.getLogger(EtiaoJobBean.class);

    public static EtiaoJobBean registerControl(ControlService cs, EtiaoJob job) {
        EtiaoJobBean bean = new EtiaoJobBean(job);
        bean.registerControl(cs);
        return bean;
    }

    private EtiaoJobBean(EtiaoJob job) {
        this.job = job;
    }

    public String getControlId() {
        return this.controlId;
    }

    public boolean wasRegistered() {
        return this.controlId != null;
    }

    public String getId() {
        return this.job.getId();
    }

    public String getName() {
        return this.job.getName();
    }

    public Job.State getCurrentState() {
        return this.job.getCurrentState();
    }

    public Job.State getNextState() {
        return this.job.getNextState();
    }

    public String graphSnapshot() {
        Gson gson = new GsonBuilder().create();
        return gson.toJson((Object)new GraphType((Graph)this.job.graph()));
    }

    public Job.Health getHealth() {
        return this.job.getHealth();
    }

    public String getLastError() {
        return this.job.getLastError();
    }

    public void stateChange(Job.Action action) {
        this.job.stateChange(action);
        if (this.wasRegistered() && action == Job.Action.CLOSE) {
            this.unregisterControlAsync();
        }
    }

    private void registerControl(ControlService cs) {
        String oldControlId;
        if (cs == null) {
            throw new IllegalArgumentException("ControlService must not be null");
        }
        logger.trace("Registering control for job id {}, job name {}", (Object)this.job.getId(), (Object)this.job.getName());
        this.controlService = cs;
        JobMXBean oldControl = (JobMXBean)cs.getControl("job", this.job.getName(), JobMXBean.class);
        if (oldControl != null && (oldControlId = cs.getControlId("job", this.job.getName(), JobMXBean.class)) != null) {
            if (this.isJobClosed(oldControl)) {
                cs.unregister(oldControlId);
                logger.debug("Old control id {} for CLOSED job name {} was unregistered", (Object)oldControlId, (Object)this.job.getName());
            } else {
                throw new IllegalStateException("Cannot register job control for alias " + this.job.getName() + " because a job control with id " + oldControlId + " for the same alias already exists and is not CLOSED");
            }
        }
        this.controlId = cs.registerControl("job", this.job.getId(), this.job.getName(), JobMXBean.class, (Object)this);
        logger.debug("Control for job id {}, job name {} was registered with id {}", new Object[]{this.job.getId(), this.job.getName(), this.controlId});
    }

    private void unregisterControlAsync() {
        if (this.controlService == null) {
            throw new IllegalStateException("The ControlService of a registered bean must not be null");
        }
        this.getThread(new Runnable(){

            @Override
            public void run() {
                EtiaoJobBean.this.unregisterControl();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterControl() {
        if (!this.wasRegistered()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            try {
                this.job.completeClosing(10L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                String cause = e.getCause() != null ? e.getCause().getMessage() : "unknown";
                logger.info("Error {} during completion of job {} caused by {}", new Object[]{e.getMessage(), this.job.getName(), cause});
                logger.debug("Error during completion of job " + this.job.getName(), (Throwable)e);
            }
            catch (TimeoutException e) {
                logger.info("Timed out after {} milliseconds waiting for job {} to complete", (Object)(System.currentTimeMillis() - startTime), (Object)this.job.getName());
            }
            long remaining = startTime + 10000L - System.currentTimeMillis();
            if (remaining < 0L) {
                remaining = 0L;
            } else {
                logger.trace("Job completed, waiting {} milliseconds before unregistering control {}", (Object)remaining, (Object)this.controlId);
            }
            Thread.sleep(remaining);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.controlService.unregister(this.controlId);
            logger.trace("Control {} unregistered", (Object)this.controlId);
        }
    }

    private Thread getThread(Runnable r) {
        ThreadFactory threads = Executors.defaultThreadFactory();
        return threads.newThread(r);
    }

    private boolean isJobClosed(JobMXBean job) {
        return job.getCurrentState() == Job.State.CLOSED && job.getNextState() == Job.State.CLOSED;
    }
}

