/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.etiao.graph.model;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.edgent.graph.Edge;
import org.apache.edgent.graph.Graph;
import org.apache.edgent.graph.Vertex;
import org.apache.edgent.runtime.etiao.graph.model.EdgeType;
import org.apache.edgent.runtime.etiao.graph.model.IdMapper;
import org.apache.edgent.runtime.etiao.graph.model.VertexType;

public class GraphType {
    private final List<VertexType<?, ?>> vertices;
    private final List<EdgeType> edges;

    public GraphType(Graph graph) {
        this(graph, null);
    }

    public GraphType(Graph g, IdMapper<String> ids) {
        if (ids == null) {
            ids = new Mapper();
        }
        ArrayList vertices = new ArrayList();
        ArrayList<EdgeType> edges = new ArrayList<EdgeType>();
        for (Vertex v : g.getVertices()) {
            VertexType vertex = new VertexType(v, ids);
            vertices.add(vertex);
        }
        for (Edge e : g.getEdges()) {
            edges.add(new EdgeType(e, ids));
        }
        this.vertices = vertices;
        this.edges = edges;
    }

    public GraphType() {
        this.vertices = null;
        this.edges = null;
    }

    public List<VertexType<?, ?>> getVertices() {
        return this.vertices;
    }

    public List<EdgeType> getEdges() {
        return this.edges;
    }

    static class Mapper
    implements IdMapper<String> {
        private int lastId = 0;
        private IdentityHashMap<Object, String> ids = new IdentityHashMap();

        Mapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String add(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            IdentityHashMap<Object, String> identityHashMap = this.ids;
            synchronized (identityHashMap) {
                String id = this.ids.get(o);
                if (id == null) {
                    id = String.valueOf(this.lastId++);
                    this.ids.put(o, id);
                }
                return id;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getId(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            IdentityHashMap<Object, String> identityHashMap = this.ids;
            synchronized (identityHashMap) {
                return this.ids.get(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String add(Object o, String id) {
            if (o == null || id == null) {
                throw new NullPointerException();
            }
            IdentityHashMap<Object, String> identityHashMap = this.ids;
            synchronized (identityHashMap) {
                if (this.ids.containsKey(o)) {
                    throw new IllegalStateException();
                }
                this.ids.put(o, id);
                return id;
            }
        }
    }
}

