/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.etiao.graph.model;

import java.util.HashSet;
import java.util.Set;
import org.apache.edgent.graph.Edge;
import org.apache.edgent.runtime.etiao.graph.model.IdMapper;

public class EdgeType {
    private final String sourceId;
    private final int sourceOutputPort;
    private final String targetId;
    private final int targetInputPort;
    private final Set<String> tags;
    private final String alias;

    public EdgeType() {
        this.sourceId = null;
        this.sourceOutputPort = 0;
        this.targetId = null;
        this.targetInputPort = 0;
        this.tags = new HashSet<String>();
        this.alias = null;
    }

    public EdgeType(Edge value, IdMapper<String> ids) {
        this.sourceId = ids.getId(value.getSource()).toString();
        this.sourceOutputPort = value.getSourceOutputPort();
        this.targetId = ids.getId(value.getTarget()).toString();
        this.targetInputPort = value.getTargetInputPort();
        this.tags = value.getTags();
        this.alias = value.getAlias();
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public int getSourceOutputPort() {
        return this.sourceOutputPort;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public int getTargetInputPort() {
        return this.targetInputPort;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public String getAlias() {
        return this.alias;
    }
}

