/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.etiao.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.edgent.function.Consumer;
import org.apache.edgent.graph.Edge;
import org.apache.edgent.graph.spi.AbstractVertex;
import org.apache.edgent.graph.spi.DirectEdge;
import org.apache.edgent.oplet.Oplet;
import org.apache.edgent.oplet.OutputPortContext;
import org.apache.edgent.runtime.etiao.Invocation;
import org.apache.edgent.runtime.etiao.graph.DirectGraph;
import org.apache.edgent.runtime.etiao.graph.EtiaoConnector;
import org.apache.edgent.runtime.etiao.graph.Target;

public class ExecutableVertex<N extends Oplet<C, P>, C, P>
extends AbstractVertex<N, C, P> {
    private static final Edge DISCONNECTED = new DirectEdge();
    private DirectGraph graph;
    private final Invocation<N, C, P> invocation;
    private final List<EtiaoConnector<P>> connectors;
    private final List<Edge> edges;

    ExecutableVertex(DirectGraph graph, Invocation<N, C, P> invocation) {
        int i;
        this.graph = graph;
        this.invocation = invocation;
        this.connectors = new ArrayList<EtiaoConnector<P>>(invocation.getOutputCount());
        for (i = 0; i < invocation.getOutputCount(); ++i) {
            this.addConnector(i);
        }
        this.edges = new ArrayList<Edge>(invocation.getOutputCount());
        for (i = 0; i < invocation.getOutputCount(); ++i) {
            this.edges.add(DISCONNECTED);
        }
    }

    private EtiaoConnector<P> addConnector(int index) {
        EtiaoConnector connector = new EtiaoConnector(this, index);
        this.connectors.add(connector);
        return connector;
    }

    public DirectGraph graph() {
        return this.graph;
    }

    public N getInstance() {
        return this.invocation.getOplet();
    }

    public EtiaoConnector<P> addOutput() {
        int outputPort = this.invocation.addOutput();
        int edgeIndex = this.addEdge();
        assert (outputPort == edgeIndex);
        return this.addConnector(outputPort);
    }

    public List<EtiaoConnector<P>> getConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public String getInvocationId() {
        return this.invocation.getId();
    }

    void disconnect(int sourcePort) {
        this.invocation.disconnect(sourcePort);
        this.edges.set(sourcePort, DISCONNECTED);
    }

    void connect(int sourcePort, Target<P> target, Edge edge) {
        if (edge == null) {
            throw new NullPointerException();
        }
        Consumer<C> input = target.vertex.invocation.getInputs().get(target.port);
        this.invocation.setTarget(sourcePort, input);
        this.edges.set(sourcePort, edge);
        this.invocation.setContext(sourcePort, new MyOutputContext(this.connectors.get(sourcePort)));
    }

    int addEdge() {
        int index = this.edges.size();
        this.edges.add(DISCONNECTED);
        return index;
    }

    List<Edge> getEdges() {
        ArrayList<Edge> connectedEdges = new ArrayList<Edge>();
        for (Edge de : this.edges) {
            if (de == DISCONNECTED) continue;
            connectedEdges.add(de);
        }
        return Collections.unmodifiableList(connectedEdges);
    }

    public String toString() {
        return "{invocation=" + this.invocation + "}";
    }

    private static class MyOutputContext
    implements OutputPortContext {
        private final String alias;

        MyOutputContext(EtiaoConnector<?> connector) {
            this.alias = connector.getAlias();
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

