/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.etiao.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.edgent.graph.Connector;
import org.apache.edgent.graph.Edge;
import org.apache.edgent.graph.Vertex;
import org.apache.edgent.graph.spi.DirectEdge;
import org.apache.edgent.oplet.Oplet;
import org.apache.edgent.oplet.core.FanOut;
import org.apache.edgent.oplet.core.Peek;
import org.apache.edgent.runtime.etiao.graph.DirectGraph;
import org.apache.edgent.runtime.etiao.graph.ExecutableVertex;
import org.apache.edgent.runtime.etiao.graph.Target;

class EtiaoConnector<P>
implements Connector<P> {
    private final ExecutableVertex<?, ?, P> vertex;
    private final int oport;
    private SharedState<P> state;

    public EtiaoConnector(ExecutableVertex<?, ?, P> vertex, int oport) {
        this.vertex = vertex;
        this.oport = oport;
        this.state = new SharedState(this);
    }

    public DirectGraph graph() {
        return this.vertex.graph();
    }

    public boolean isConnected() {
        return this.state.connectTarget != null && this == this.state.primaryConnector;
    }

    private boolean isFanOut() {
        return this.state.fanOutVertex != null;
    }

    public void connect(Vertex<?, P, ?> target, int targetPort) {
        EtiaoConnector fanOutConnector;
        if (!this.isConnected()) {
            this.state.connectTarget = this.connectActiveDirect(new Target((ExecutableVertex)target, targetPort));
            return;
        }
        if (!this.isFanOut()) {
            this.state.fanOutVertex = this.newInternalVertex(new FanOut(), 1, 1);
            fanOutConnector = this.state.fanOutVertex.getConnectors().get(0);
            super.takeTarget();
            this.state.connectTarget = this.connectActiveDirect(new Target(this.state.fanOutVertex, 0));
        }
        fanOutConnector = this.state.fanOutVertex.addOutput();
        fanOutConnector.state = this.state;
        super.connectDirect(new Target((ExecutableVertex)target, targetPort));
        assert (this.isConnected());
    }

    public <N extends Peek<P>> Connector<P> peek(N oplet) {
        ExecutableVertex<N, P, P> peekVertex = this.newInternalVertex(oplet, 1, 1);
        EtiaoConnector<P> peekConnector = peekVertex.getConnectors().get(0);
        if (this.isConnected()) {
            super.takeTarget();
        }
        this.connectActiveDirect(new Target<P>(peekVertex, 0));
        this.state.activeConnector = peekConnector;
        return this;
    }

    private <N extends Oplet<P, P>> ExecutableVertex<N, P, P> newInternalVertex(N op, int nInputs, int nOutputs) {
        ExecutableVertex vertex = this.graph().insert(op, nInputs, nOutputs);
        for (EtiaoConnector connector : vertex.getConnectors()) {
            connector.state = this.state;
        }
        return vertex;
    }

    private Target<P> disconnectTarget() {
        assert (this.state.connectTarget != null);
        this.state.activeConnector.vertex.disconnect(this.state.activeConnector.oport);
        Target target = this.state.connectTarget;
        this.state.connectTarget = null;
        assert (this.state.connectTarget == null);
        return target;
    }

    private void takeTarget() {
        this.state.connectTarget = this.connectDirect(this.disconnectTarget());
    }

    private Target<P> connectDirect(Target<P> target) {
        this.vertex.connect(this.oport, target, (Edge)new DirectEdge((Connector)this, this.vertex, this.oport, target.vertex, target.port));
        return target;
    }

    private Target<P> connectActiveDirect(Target<P> target) {
        ExecutableVertex<?, ?, P> vertex = this.state.activeConnector.vertex;
        int oport = this.state.activeConnector.oport;
        vertex.connect(oport, target, (Edge)new DirectEdge(this.state.activeConnector, vertex, oport, target.vertex, target.port));
        return target;
    }

    public void tag(String ... values) {
        for (String v : values) {
            ((SharedState)this.state).tags.add(v);
        }
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(((SharedState)this.state).tags);
    }

    public void alias(String alias) {
        if (this.state.alias != null) {
            throw new IllegalStateException("alias already set");
        }
        this.state.alias = alias;
    }

    public String getAlias() {
        return this.state.alias;
    }

    public String toString() {
        return "{" + this.getClass().getSimpleName() + " oport=" + this.oport + " vertex=" + this.vertex + " state=" + this.state + "}";
    }

    private static class SharedState<P> {
        String alias;
        private Set<String> tags = new HashSet<String>();
        EtiaoConnector<P> primaryConnector;
        EtiaoConnector<P> activeConnector;
        Target<P> connectTarget;
        ExecutableVertex<FanOut<P>, P, P> fanOutVertex;

        public SharedState(EtiaoConnector<P> connector) {
            this.primaryConnector = connector;
            this.activeConnector = connector;
        }

        public String toString() {
            return "{ activeConnector=<" + ((EtiaoConnector)this.activeConnector).oport + "," + (Object)((Object)((EtiaoConnector)this.activeConnector).vertex) + "> primaryConnector=<" + ((EtiaoConnector)this.primaryConnector).oport + "," + (Object)((Object)((EtiaoConnector)this.primaryConnector).vertex) + "> connectTarget=" + this.connectTarget + " fanOutVertex=" + this.fanOutVertex + " alias=" + this.alias + " tags=" + this.tags + "}";
        }
    }
}

