/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.etiao.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.edgent.execution.services.ServiceContainer;
import org.apache.edgent.graph.Edge;
import org.apache.edgent.graph.Vertex;
import org.apache.edgent.graph.spi.AbstractGraph;
import org.apache.edgent.oplet.Oplet;
import org.apache.edgent.runtime.etiao.Executable;
import org.apache.edgent.runtime.etiao.Invocation;
import org.apache.edgent.runtime.etiao.graph.ExecutableVertex;

public class DirectGraph
extends AbstractGraph<Executable> {
    private final Executable executable;
    private final List<ExecutableVertex<? extends Oplet<?, ?>, ?, ?>> vertices = new ArrayList();

    public DirectGraph(String topologyName, ServiceContainer container) {
        this.executable = new Executable(topologyName, container);
    }

    public Executable executable() {
        return this.executable;
    }

    public <OP extends Oplet<C, P>, C, P> ExecutableVertex<OP, C, P> insert(OP oplet, int inputs, int outputs) {
        Invocation invocation = this.executable().addOpletInvocation(oplet, inputs, outputs);
        ExecutableVertex vertex = new ExecutableVertex(this, invocation);
        this.vertices.add(vertex);
        return vertex;
    }

    public Collection<Vertex<? extends Oplet<?, ?>, ?, ?>> getVertices() {
        return Collections.unmodifiableList(this.vertices);
    }

    public Collection<Edge> getEdges() {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (ExecutableVertex<Oplet<?, ?>, ?, ?> ev : this.vertices) {
            for (Edge e : ev.getEdges()) {
                edges.add(e);
            }
        }
        return Collections.unmodifiableList(edges);
    }
}

