/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.etiao;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.edgent.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrackingScheduledExecutor
extends ScheduledThreadPoolExecutor {
    private final BiConsumer<Object, Throwable> completer;
    private static final Logger logger = LoggerFactory.getLogger(TrackingScheduledExecutor.class);
    private final Set<RunnableScheduledFuture<?>> asyncTasks = Collections.synchronizedSet(new HashSet());

    public static TrackingScheduledExecutor newScheduler(ThreadFactory threadFactory, BiConsumer<Object, Throwable> completionHandler) {
        TrackingScheduledExecutor stpe = new TrackingScheduledExecutor(Runtime.getRuntime().availableProcessors() * 4, threadFactory, completionHandler);
        stpe.setKeepAliveTime(1L, TimeUnit.SECONDS);
        stpe.allowCoreThreadTimeOut(true);
        return stpe;
    }

    private TrackingScheduledExecutor(int corePoolSize, ThreadFactory tf, BiConsumer<Object, Throwable> completer) {
        super(corePoolSize, tf);
        this.completer = completer;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            t = this.unwrapFutureThrowable((Future)((Object)r));
        }
        if (t != null) {
            this.getLogger().error("Thread: " + Thread.currentThread().getName() + ": task terminated with exception : ", t);
            this.cleanup();
            this.completer.accept((Object)this, (Object)t);
        }
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return this.trackTask(task);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> c, RunnableScheduledFuture<V> task) {
        return this.trackTask(task);
    }

    private void cleanup() {
        this.cancelAllAsyncTasks(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cancelAllAsyncTasks(boolean mayInterruptIfRunning) {
        int notCanceled = 0;
        Set<RunnableScheduledFuture<?>> set = this.asyncTasks;
        synchronized (set) {
            for (RunnableScheduledFuture<?> task : this.asyncTasks) {
                if (task.cancel(mayInterruptIfRunning)) continue;
                ++notCanceled;
            }
            this.hasActiveTasks();
        }
        return notCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> RunnableScheduledFuture<V> trackTask(RunnableScheduledFuture<V> task) {
        task = new TrackedFuture<V>(task);
        Set<RunnableScheduledFuture<?>> set = this.asyncTasks;
        synchronized (set) {
            this.asyncTasks.add(task);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveTasks() {
        boolean doesHaveTasks = false;
        Set<RunnableScheduledFuture<?>> set = this.asyncTasks;
        synchronized (set) {
            if (this.asyncTasks.isEmpty()) {
                return false;
            }
            Iterator<RunnableScheduledFuture<?>> i = this.asyncTasks.iterator();
            while (i.hasNext()) {
                RunnableScheduledFuture<?> task = i.next();
                if (task.isDone()) {
                    i.remove();
                    continue;
                }
                doesHaveTasks = true;
            }
        }
        return doesHaveTasks;
    }

    private final Throwable unwrapFutureThrowable(Future<?> ft) {
        if (ft.isDone() && !ft.isCancelled()) {
            try {
                ft.get();
            }
            catch (ExecutionException ee) {
                return ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    private Logger getLogger() {
        return logger;
    }

    final class TrackedFuture<V>
    implements RunnableScheduledFuture<V> {
        private final RunnableScheduledFuture<V> realTask;

        TrackedFuture(RunnableScheduledFuture<V> realTask) {
            this.realTask = realTask;
        }

        @Override
        public void run() {
            try {
                this.realTask.run();
            }
            finally {
                if (!this.isPeriodic()) {
                    this.removeTrack();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeTrack() {
            Set set = TrackingScheduledExecutor.this.asyncTasks;
            synchronized (set) {
                TrackingScheduledExecutor.this.asyncTasks.remove(this);
            }
            if (TrackingScheduledExecutor.this.asyncTasks.isEmpty() || TrackingScheduledExecutor.this.getActiveCount() <= 1 && TrackingScheduledExecutor.this.getQueue().isEmpty()) {
                TrackingScheduledExecutor.this.completer.accept((Object)TrackingScheduledExecutor.this, null);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean wasCancelled = this.realTask.cancel(mayInterruptIfRunning);
            if (wasCancelled) {
                this.removeTrack();
            }
            return wasCancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.realTask.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.realTask.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.realTask.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.realTask.get(timeout, unit);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.realTask.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.realTask.compareTo(o);
        }

        @Override
        public boolean isPeriodic() {
            return this.realTask.isPeriodic();
        }
    }
}

