/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.etiao;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.edgent.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadFactoryTracker
implements ThreadFactory {
    private final String threadName;
    private final ThreadFactory factory;
    private final BiConsumer<Object, Throwable> completer;
    private final Thread.UncaughtExceptionHandler handler;
    private volatile boolean shutdown;
    private final ThreadSets threads = new ThreadSets();
    private static final Logger logger = LoggerFactory.getLogger(ThreadFactoryTracker.class);

    ThreadFactoryTracker(String threadName, ThreadFactory tf, final BiConsumer<Object, Throwable> completer) {
        this.threadName = threadName;
        this.factory = tf != null ? tf : Executors.defaultThreadFactory();
        this.completer = completer;
        this.handler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                try {
                    if (!ThreadFactoryTracker.this.trackedThreadUncaughtException(thread, throwable)) {
                        Thread.getDefaultUncaughtExceptionHandler().uncaughtException(thread, throwable);
                    }
                }
                finally {
                    ThreadFactoryTracker.this.threads.removeRunning(Thread.currentThread());
                    completer.accept((Object)this, (Object)throwable);
                }
            }
        };
    }

    @Override
    public Thread newThread(final Runnable r) {
        if (this.shutdown) {
            return null;
        }
        Runnable wrapper = new Runnable(){

            @Override
            public void run() {
                ThreadFactoryTracker.this.threads.fromNewToRunning(Thread.currentThread());
                r.run();
                ThreadFactoryTracker.this.threads.removeRunning(Thread.currentThread());
                if (!ThreadFactoryTracker.this.hasActiveNonDaemonThreads()) {
                    ThreadFactoryTracker.this.completer.accept((Object)ThreadFactoryTracker.this, null);
                }
            }
        };
        Thread t = this.factory.newThread(wrapper);
        t.setName(t.getName() + "-" + this.threadName);
        t.setUncaughtExceptionHandler(this.handler);
        this.threads.addNew(t);
        return t;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void shutdownNow() {
        Thread[] leftoverThreads;
        this.shutdown();
        for (Thread t : leftoverThreads = this.threads.runningArray()) {
            t.interrupt();
        }
        for (Thread t : leftoverThreads) {
            try {
                t.join(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean hasActiveNonDaemonThreads() {
        return this.threads.hasActiveNonDaemonThreads();
    }

    private boolean trackedThreadUncaughtException(Thread t, Throwable e) {
        this.getLogger().error("Uncaught exception in thread " + t.getName(), e);
        return true;
    }

    private Logger getLogger() {
        return logger;
    }

    private static class ThreadSets {
        private final Set<Thread> newThreads = new HashSet<Thread>();
        private final Set<Thread> runningThreads = new HashSet<Thread>();

        private ThreadSets() {
        }

        synchronized void addNew(Thread t) {
            this.newThreads.add(t);
        }

        synchronized void removeRunning(Thread t) {
            this.runningThreads.remove(t);
        }

        synchronized void fromNewToRunning(Thread t) {
            this.newThreads.remove(t);
            this.runningThreads.add(t);
        }

        synchronized Thread[] runningArray() {
            return this.runningThreads.toArray(new Thread[0]);
        }

        synchronized boolean hasActiveNonDaemonThreads() {
            if (this.runningThreads.isEmpty() && this.newThreads.isEmpty()) {
                return false;
            }
            for (Thread t : this.runningThreads) {
                if (t.isDaemon()) continue;
                return true;
            }
            for (Thread t : this.newThreads) {
                if (t.isDaemon()) continue;
                return true;
            }
            return false;
        }
    }
}

