/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.etiao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.edgent.execution.services.RuntimeServices;
import org.apache.edgent.function.Consumer;
import org.apache.edgent.function.Functions;
import org.apache.edgent.oplet.JobContext;
import org.apache.edgent.oplet.Oplet;
import org.apache.edgent.oplet.OutputPortContext;
import org.apache.edgent.runtime.etiao.InvocationContext;
import org.apache.edgent.runtime.etiao.SettableForwarder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Invocation<T extends Oplet<I, O>, I, O>
implements AutoCloseable {
    public static final String ID_PREFIX = "OP_";
    private static final OutputPortContext DEFAULT_OUTPUT_CONTEXT = new OutputPortContext(){

        public String getAlias() {
            return null;
        }
    };
    private final String id;
    private T oplet;
    private List<Consumer<O>> outputs;
    private List<SettableForwarder<I>> inputs;
    private List<OutputPortContext> outputContext;
    private static final Logger logger = LoggerFactory.getLogger(Invocation.class);

    protected Invocation(String id, T oplet, int inputCount, int outputCount) {
        int i;
        this.id = id;
        this.oplet = oplet;
        this.inputs = inputCount == 0 ? Collections.emptyList() : new ArrayList(inputCount);
        for (i = 0; i < inputCount; ++i) {
            this.inputs.add(new SettableForwarder());
        }
        this.outputs = outputCount == 0 ? Collections.emptyList() : new ArrayList(outputCount);
        this.outputContext = outputCount == 0 ? Collections.emptyList() : new ArrayList(outputCount);
        for (i = 0; i < outputCount; ++i) {
            this.addOutput();
        }
    }

    public String getId() {
        return this.id;
    }

    public T getOplet() {
        return this.oplet;
    }

    public int getOutputCount() {
        return this.outputs.size();
    }

    public int addOutput() {
        int index = this.outputs.size();
        this.outputs.add(Functions.discard());
        this.outputContext.add(DEFAULT_OUTPUT_CONTEXT);
        return index;
    }

    public void disconnect(int port) {
        this.outputs.set(port, Functions.discard());
    }

    public void setTarget(int port, Consumer<O> target) {
        this.disconnect(port);
        this.outputs.set(port, target);
    }

    public void setContext(int port, OutputPortContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.outputContext.set(port, context);
    }

    public List<? extends Consumer<I>> getInputs() {
        return this.inputs;
    }

    public void initialize(JobContext job, RuntimeServices services) {
        InvocationContext context = new InvocationContext(this.id, job, services, this.inputs.size(), this.outputs, this.outputContext);
        try {
            this.oplet.initialize(context);
        }
        catch (Exception e) {
            logger.error("Error while initializing oplet", (Throwable)e);
        }
        List streamers = this.oplet.getInputs();
        for (int i = 0; i < this.inputs.size(); ++i) {
            this.inputs.get(i).setDestination((Consumer)streamers.get(i));
        }
    }

    public void start() {
        this.oplet.start();
    }

    @Override
    public void close() throws Exception {
        this.oplet.close();
    }

    public String toString() {
        return "{id=" + this.getId() + " oplet=" + this.oplet.getClass().getSimpleName() + "}";
    }
}

