/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.etiao;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.edgent.execution.Job;
import org.apache.edgent.execution.services.ControlService;
import org.apache.edgent.execution.services.JobRegistryService;
import org.apache.edgent.execution.services.ServiceContainer;
import org.apache.edgent.graph.spi.execution.AbstractGraphJob;
import org.apache.edgent.oplet.JobContext;
import org.apache.edgent.runtime.etiao.Executable;
import org.apache.edgent.runtime.etiao.graph.DirectGraph;
import org.apache.edgent.runtime.etiao.mbeans.EtiaoJobBean;

public class EtiaoJob
extends AbstractGraphJob
implements JobContext {
    public static final String ID_PREFIX = "JOB_";
    private final DirectGraph graph;
    private final String id;
    private final String topologyName;
    private final String name;
    private final ServiceContainer containerServices;
    private final JobRegistryService jobs;
    private static final AtomicInteger jobID = new AtomicInteger(0);
    static final HashMap<Job.State, EnumSet<Job.State>> stateMap = new HashMap();

    EtiaoJob(DirectGraph graph, String topologyName, String jobName, ServiceContainer container) {
        this.graph = graph;
        this.id = ID_PREFIX + String.valueOf(jobID.getAndIncrement());
        this.topologyName = topologyName;
        if (jobName == null) {
            jobName = this.topologyName + "_" + this.id;
        }
        this.name = jobName;
        this.containerServices = container;
        ControlService cs = (ControlService)container.getService(ControlService.class);
        if (cs != null) {
            EtiaoJobBean.registerControl(cs, this);
        }
        this.jobs = (JobRegistryService)container.getService(JobRegistryService.class);
        if (this.jobs != null) {
            this.jobs.addJob((Job)this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    ServiceContainer getContainerServices() {
        return this.containerServices;
    }

    public void stateChange(Job.Action action) {
        switch (action) {
            case INITIALIZE: {
                this.setNext(Job.State.INITIALIZED, action);
                this.executable().initialize();
                break;
            }
            case START: {
                this.setNext(Job.State.RUNNING, action);
                this.executable().start();
                break;
            }
            case PAUSE: 
            case RESUME: {
                throw new UnsupportedOperationException(action.name());
            }
            case CLOSE: {
                Job.State s = this.setNext(Job.State.CLOSED, action);
                if (s != Job.State.CLOSED) {
                    this.executable().close();
                    break;
                }
                this.completeTransition();
                break;
            }
            default: {
                throw new IllegalArgumentException(action.name());
            }
        }
    }

    Executable executable() {
        return this.graph.executable();
    }

    private synchronized Job.State setNext(Job.State desiredState, Job.Action cause) {
        if (!this.isReachable(desiredState)) {
            throw new IllegalArgumentException(cause.name());
        }
        this.setNextState(desiredState);
        this.updateRegistry();
        return this.getCurrentState();
    }

    private boolean isReachable(Job.State desiredState) {
        return !this.inTransition() && stateMap.get(this.getCurrentState()).contains(desiredState);
    }

    protected synchronized void completeTransition() {
        super.completeTransition();
        this.updateRegistry();
    }

    void onActionComplete() {
        this.completeTransition();
    }

    public void complete() throws ExecutionException, InterruptedException {
        if (this.getCurrentState() != Job.State.CLOSED && this.getNextState() != Job.State.CLOSED) {
            this.awaitComplete(Long.MAX_VALUE);
        }
    }

    public void complete(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (this.getCurrentState() != Job.State.CLOSED && this.getNextState() != Job.State.CLOSED && !this.awaitComplete(unit.toMillis(timeout))) {
            throw new TimeoutException();
        }
    }

    public void completeClosing(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (this.getCurrentState() != Job.State.CLOSED && !this.awaitComplete(unit.toMillis(timeout))) {
            throw new TimeoutException();
        }
    }

    private boolean awaitComplete(long millis) throws ExecutionException, InterruptedException {
        try {
            return this.executable().complete(millis);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Executable.executionException(t);
        }
    }

    public DirectGraph graph() {
        return this.graph;
    }

    private void updateRegistry() {
        if (this.jobs != null) {
            this.jobs.updateJob((Job)this);
        }
    }

    void updateHealth(Throwable t) {
        if (t != null) {
            this.setHealth(Job.Health.UNHEALTHY);
            this.setLastError(t.getMessage());
        }
        this.updateRegistry();
    }

    static {
        stateMap.put(Job.State.CONSTRUCTED, EnumSet.of(Job.State.INITIALIZED, Job.State.CLOSED));
        stateMap.put(Job.State.INITIALIZED, EnumSet.of(Job.State.RUNNING, Job.State.CLOSED));
        stateMap.put(Job.State.RUNNING, EnumSet.of(Job.State.PAUSED, Job.State.CLOSED));
        stateMap.put(Job.State.PAUSED, EnumSet.of(Job.State.RUNNING, Job.State.CLOSED));
        stateMap.put(Job.State.CLOSED, EnumSet.of(Job.State.CLOSED));
    }
}

