/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.appservice;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.concurrent.ExecutionException;
import org.apache.edgent.function.BiConsumer;
import org.apache.edgent.runtime.appservice.AppService;
import org.apache.edgent.topology.Topology;
import org.apache.edgent.topology.mbeans.ApplicationServiceMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppServiceControl
implements ApplicationServiceMXBean {
    private final AppService service;
    private static final Logger logger = LoggerFactory.getLogger(AppServiceControl.class);

    AppServiceControl(AppService service) {
        this.service = service;
    }

    public void submit(String applicationName, String jsonConfig) throws Exception {
        BiConsumer<Topology, JsonObject> builder = this.service.getBuilder(applicationName);
        if (builder == null) {
            return;
        }
        JsonObject config = jsonConfig != null && !jsonConfig.isEmpty() ? (JsonObject)new JsonParser().parse(jsonConfig) : new JsonObject();
        Topology topology = this.service.getProvider().newTopology(applicationName);
        builder.accept((Object)topology, (Object)config);
        if (!config.has("jobName")) {
            config.addProperty("jobName", applicationName);
        }
        try {
            this.service.getSubmitter().submit((Object)topology, config).get();
        }
        catch (InterruptedException e) {
            logger.error("Exception caught while waiting for submitted executable", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw (Exception)t;
        }
    }

    public void registerJar(String jarURL, String jsonConfig) throws Exception {
        this.service.registerJar(jarURL, jsonConfig);
    }
}

