/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.runtime.appservice;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.edgent.execution.DirectSubmitter;
import org.apache.edgent.execution.Job;
import org.apache.edgent.execution.services.ControlService;
import org.apache.edgent.function.BiConsumer;
import org.apache.edgent.runtime.appservice.AppServiceControl;
import org.apache.edgent.topology.Topology;
import org.apache.edgent.topology.TopologyProvider;
import org.apache.edgent.topology.mbeans.ApplicationServiceMXBean;
import org.apache.edgent.topology.services.ApplicationService;
import org.apache.edgent.topology.services.TopologyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppService
implements ApplicationService {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationService.class);
    private final Map<String, BiConsumer<Topology, JsonObject>> applications = Collections.synchronizedMap(new HashMap());
    private final TopologyProvider provider;
    private final DirectSubmitter<Topology, Job> submitter;

    public static ApplicationService createAndRegister(TopologyProvider provider, DirectSubmitter<Topology, Job> submitter) {
        AppService service = new AppService(provider, submitter, "edgent");
        submitter.getServices().addService(ApplicationService.class, (Object)service);
        return service;
    }

    public AppService(TopologyProvider provider, DirectSubmitter<Topology, Job> submitter, String alias) {
        this.provider = provider;
        this.submitter = submitter;
        ControlService cs = (ControlService)submitter.getServices().getService(ControlService.class);
        if (cs != null) {
            cs.registerControl("appService", "edgent" + System.currentTimeMillis(), alias, ApplicationServiceMXBean.class, (Object)new AppServiceControl(this));
        }
    }

    public void registerTopology(String applicationName, BiConsumer<Topology, JsonObject> builder) {
        if (applicationName == null || applicationName.isEmpty()) {
            throw new IllegalArgumentException();
        }
        logger.trace("Register application name: {}", (Object)applicationName);
        this.applications.put(applicationName, builder);
    }

    public void registerJar(String jarURL, String jsonConfig) throws Exception {
        logger.trace("Register jar: {}", (Object)jarURL);
        URL url = new URL(jarURL);
        String protocol = url.getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            url = this.downloadJar(url);
        }
        URLClassLoader loader = new URLClassLoader(new URL[]{url});
        for (TopologyBuilder topoBuilder : ServiceLoader.load(TopologyBuilder.class, loader)) {
            this.registerTopology(topoBuilder.getName(), (BiConsumer<Topology, JsonObject>)topoBuilder.getBuilder());
        }
    }

    private URL downloadJar(URL url) throws Exception {
        int bytesRead;
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        int responseCode = httpConn.getResponseCode();
        if (responseCode != 200) {
            logger.error("Error response code for URL: {} : response code={}", (Object)url.toExternalForm(), (Object)responseCode);
            throw new IOException();
        }
        String fileName = "";
        String disposition = httpConn.getHeaderField("Content-Disposition");
        if (disposition != null) {
            int index = disposition.indexOf("filename=");
            if (index > 0) {
                fileName = disposition.substring(index + 10, disposition.length() - 1);
            }
        } else {
            String path = url.getPath();
            if (!path.isEmpty()) {
                int lastSlash = path.lastIndexOf("/");
                fileName = lastSlash == -1 ? path : path.substring(lastSlash + 1);
            }
        }
        Path dir = Files.createTempDirectory("edgentjars", new FileAttribute[0]);
        File file = fileName.isEmpty() ? File.createTempFile("edgent", "jar", dir.toFile()) : new File(dir.toFile(), fileName);
        InputStream inputStream = httpConn.getInputStream();
        FileOutputStream outputStream = new FileOutputStream(file);
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();
        logger.trace("Register jar downloaded as: {}", (Object)file);
        return file.toURI().toURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getApplicationNames() {
        Map<String, BiConsumer<Topology, JsonObject>> map = this.applications;
        synchronized (map) {
            return new HashSet<String>(this.applications.keySet());
        }
    }

    BiConsumer<Topology, JsonObject> getBuilder(String applicationName) {
        return this.applications.get(applicationName);
    }

    TopologyProvider getProvider() {
        return this.provider;
    }

    DirectSubmitter<Topology, Job> getSubmitter() {
        return this.submitter;
    }
}

