/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.window;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.edgent.function.BiConsumer;
import org.apache.edgent.function.BiFunction;
import org.apache.edgent.function.Consumer;
import org.apache.edgent.function.Function;
import org.apache.edgent.function.Supplier;
import org.apache.edgent.window.Partition;
import org.apache.edgent.window.PartitionImpl;
import org.apache.edgent.window.Window;

class WindowImpl<T, K, L extends List<T>>
implements Window<T, K, L> {
    private final BiFunction<Partition<T, K, L>, T, Boolean> insertionPolicy;
    private final BiConsumer<Partition<T, K, L>, T> contentsPolicy;
    private final Consumer<Partition<T, K, L>> evictDeterminer;
    private final BiConsumer<Partition<T, K, L>, T> triggerPolicy;
    private BiConsumer<List<T>, K> partitionProcessor;
    private ScheduledExecutorService ses;
    protected Supplier<L> listSupplier;
    protected Function<T, K> keyFunction;
    private Map<K, Partition<T, K, L>> partitions = new HashMap<K, Partition<T, K, L>>();

    WindowImpl(BiFunction<Partition<T, K, L>, T, Boolean> insertionPolicy, BiConsumer<Partition<T, K, L>, T> contentsPolicy, Consumer<Partition<T, K, L>> evictDeterminer, BiConsumer<Partition<T, K, L>, T> triggerPolicy, Function<T, K> keyFunction, Supplier<L> listSupplier) {
        this.insertionPolicy = insertionPolicy;
        this.contentsPolicy = contentsPolicy;
        this.evictDeterminer = evictDeterminer;
        this.triggerPolicy = triggerPolicy;
        this.keyFunction = keyFunction;
        this.listSupplier = listSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(T tuple) {
        Partition<T, K, L> partition;
        Object key = this.keyFunction.apply(tuple);
        Map<K, Partition<T, K, L>> map = this.partitions;
        synchronized (map) {
            partition = this.partitions.get(key);
            if (partition == null) {
                partition = new PartitionImpl(this, (List)this.listSupplier.get(), key);
                this.partitions.put(key, partition);
            }
        }
        return partition.insert(tuple);
    }

    @Override
    public synchronized void registerPartitionProcessor(BiConsumer<List<T>, K> partitionProcessor) {
        this.partitionProcessor = partitionProcessor;
    }

    @Override
    public BiConsumer<Partition<T, K, L>, T> getContentsPolicy() {
        return this.contentsPolicy;
    }

    @Override
    public BiConsumer<Partition<T, K, L>, T> getTriggerPolicy() {
        return this.triggerPolicy;
    }

    @Override
    public synchronized BiConsumer<List<T>, K> getPartitionProcessor() {
        return this.partitionProcessor;
    }

    @Override
    public BiFunction<Partition<T, K, L>, T, Boolean> getInsertionPolicy() {
        return this.insertionPolicy;
    }

    @Override
    public Consumer<Partition<T, K, L>> getEvictDeterminer() {
        return this.evictDeterminer;
    }

    @Override
    public Function<T, K> getKeyFunction() {
        return this.keyFunction;
    }

    @Override
    public synchronized void registerScheduledExecutorService(ScheduledExecutorService ses) {
        this.ses = ses;
    }

    @Override
    public synchronized ScheduledExecutorService getScheduledExecutorService() {
        return this.ses;
    }

    @Override
    public Map<K, Partition<T, K, L>> getPartitions() {
        return this.partitions;
    }
}

