/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.window;

import java.util.Collections;
import java.util.List;
import org.apache.edgent.function.Consumer;
import org.apache.edgent.window.Partition;
import org.apache.edgent.window.Window;

class PartitionImpl<T, K, L extends List<T>>
implements Partition<T, K, L> {
    private final L tuples;
    private final List<T> unmodifiableTuples;
    private final Window<T, K, L> window;
    private final K key;

    PartitionImpl(Window<T, K, L> window, L tuples, K key) {
        this.window = window;
        this.tuples = tuples;
        this.unmodifiableTuples = Collections.unmodifiableList(tuples);
        this.key = key;
    }

    @Override
    public synchronized boolean insert(T tuple) {
        if (((Boolean)this.getWindow().getInsertionPolicy().apply((Object)this, tuple)).booleanValue()) {
            this.getWindow().getContentsPolicy().accept((Object)this, tuple);
            this.tuples.add(tuple);
            this.getWindow().getTriggerPolicy().accept((Object)this, tuple);
            return true;
        }
        return true;
    }

    @Override
    public synchronized void process() {
        this.window.getPartitionProcessor().accept(this.unmodifiableTuples, this.key);
    }

    @Override
    public synchronized L getContents() {
        return this.tuples;
    }

    @Override
    public Window<T, K, L> getWindow() {
        return this.window;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public synchronized void evict() {
        Consumer<Partition<T, K, L>> evictDeterminer = this.window.getEvictDeterminer();
        evictDeterminer.accept((Object)this);
    }
}

