/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.window;

import java.util.AbstractSequentialList;
import java.util.LinkedList;
import java.util.ListIterator;

public class InsertionTimeList<T>
extends AbstractSequentialList<T> {
    private final LinkedList<T> tuples = new LinkedList();
    private final LinkedList<Long> times = new LinkedList();

    void evictOlderThan(long evictTime) {
        while (!this.times.isEmpty() && this.times.getFirst() <= evictTime) {
            this.remove();
        }
    }

    long nextEvictDelay(long timeMs) {
        long firstTupleTime = this.times.get(0);
        long nextEvictTime = firstTupleTime + timeMs;
        long timeToNextEvict = nextEvictTime - System.currentTimeMillis();
        return Math.max(0L, timeToNextEvict);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new TimedListIterator<T>(this.tuples.listIterator(index), this.times.listIterator(index));
    }

    @Override
    public boolean add(T tuple) {
        this.tuples.add(tuple);
        this.times.add(System.currentTimeMillis());
        return true;
    }

    @Override
    public void clear() {
        this.tuples.clear();
        this.times.clear();
    }

    private void remove() {
        this.tuples.remove();
        this.times.remove();
    }

    @Override
    public int size() {
        return this.tuples.size();
    }

    private static class TimedListIterator<T>
    implements ListIterator<T> {
        private final ListIterator<T> ti;
        private final ListIterator<Long> iti;

        TimedListIterator(ListIterator<T> ti, ListIterator<Long> iti) {
            this.ti = ti;
            this.iti = iti;
        }

        @Override
        public void add(T tuple) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.ti.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.ti.hasPrevious();
        }

        @Override
        public T next() {
            this.iti.next();
            return this.ti.next();
        }

        @Override
        public int nextIndex() {
            return this.ti.nextIndex();
        }

        @Override
        public T previous() {
            this.iti.previous();
            return this.ti.previous();
        }

        @Override
        public int previousIndex() {
            return this.ti.previousIndex();
        }

        @Override
        public void remove() {
            this.ti.remove();
            this.iti.remove();
        }

        @Override
        public void set(T arg0) {
            throw new UnsupportedOperationException();
        }
    }
}

