/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.topology.plumbing;

import java.util.Arrays;
import java.util.concurrent.Semaphore;
import org.apache.edgent.function.ToIntFunction;

public class LoadBalancedSplitter<T>
implements ToIntFunction<T> {
    private static final long serialVersionUID = 1L;
    private final Semaphore gate;
    private final boolean[] chBusy;

    public LoadBalancedSplitter(int numChannels) {
        if (numChannels < 1) {
            throw new IllegalArgumentException("numChannels");
        }
        this.chBusy = new boolean[numChannels];
        Arrays.fill(this.chBusy, false);
        this.gate = new Semaphore(numChannels);
    }

    public synchronized void channelDone(int channel) {
        if (!this.chBusy[channel]) {
            throw new IllegalStateException("channel " + channel + " is not busy");
        }
        this.chBusy[channel] = false;
        this.gate.release();
    }

    public int applyAsInt(T value) {
        try {
            this.gate.acquire();
            LoadBalancedSplitter loadBalancedSplitter = this;
            synchronized (loadBalancedSplitter) {
                for (int ch = 0; ch < this.chBusy.length; ++ch) {
                    if (this.chBusy[ch]) continue;
                    this.chBusy[ch] = true;
                    return ch;
                }
                throw new IllegalStateException("internal error");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted", e);
        }
    }
}

