/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.topology.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.edgent.function.Function;

public class JsonFunctions {
    private static final JsonElement ZERO_ELEMENT = new JsonParser().parse("0");
    private static final Function<JsonObject, JsonElement> ZERO = (Function & Serializable)jo -> ZERO_ELEMENT;

    public static Function<JsonObject, String> asString() {
        return (Function & Serializable)jo -> jo.toString();
    }

    public static Function<String, JsonObject> fromString() {
        JsonParser jp = new JsonParser();
        return (Function & Serializable)json -> jp.parse(json).getAsJsonObject();
    }

    public static Function<JsonObject, byte[]> asBytes() {
        return (Function & Serializable)jo -> jo.toString().getBytes(StandardCharsets.UTF_8);
    }

    public static Function<byte[], JsonObject> fromBytes() {
        JsonParser jp = new JsonParser();
        return (Function & Serializable)jsonbytes -> jp.parse(new String((byte[])jsonbytes, StandardCharsets.UTF_8)).getAsJsonObject();
    }

    public static Function<JsonObject, JsonElement> unpartitioned() {
        return ZERO;
    }

    public static <T extends Number> Function<T, JsonObject> valueOfNumber(String propName) {
        return (Function & Serializable)v -> {
            JsonObject jo = new JsonObject();
            jo.addProperty(propName, v);
            return jo;
        };
    }

    public static Function<Boolean, JsonObject> valueOfBoolean(String propName) {
        return (Function & Serializable)v -> {
            JsonObject jo = new JsonObject();
            jo.addProperty(propName, v);
            return jo;
        };
    }

    public static Function<String, JsonObject> valueOfString(String propName) {
        return (Function & Serializable)v -> {
            JsonObject jo = new JsonObject();
            jo.addProperty(propName, v);
            return jo;
        };
    }

    public static Function<Character, JsonObject> valueOfCharacter(String propName) {
        return (Function & Serializable)v -> {
            JsonObject jo = new JsonObject();
            jo.addProperty(propName, v);
            return jo;
        };
    }
}

