/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.oplet.plumbing;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.edgent.oplet.OpletContext;
import org.apache.edgent.oplet.core.Pipe;

public class Isolate<T>
extends Pipe<T, T> {
    private static final long serialVersionUID = 1L;
    private Thread thread;
    private final LinkedBlockingQueue<T> tuples;

    public Isolate() {
        this(Integer.MAX_VALUE);
    }

    public Isolate(int queueCapacity) {
        this.tuples = new LinkedBlockingQueue(queueCapacity);
    }

    @Override
    public void initialize(OpletContext<T, T> context) {
        super.initialize(context);
        this.thread = context.getService(ThreadFactory.class).newThread(() -> this.run());
    }

    @Override
    public void start() {
        super.start();
        this.thread.start();
    }

    public void accept(T tuple) {
        try {
            this.tuples.put(tuple);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void run() {
        while (!Thread.interrupted()) {
            try {
                this.submit(this.tuples.take());
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    @Override
    public void close() throws Exception {
    }
}

