/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.function;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.apache.edgent.function.BiFunction;
import org.apache.edgent.function.Consumer;
import org.apache.edgent.function.Function;
import org.apache.edgent.function.Predicate;
import org.apache.edgent.function.Supplier;
import org.apache.edgent.function.UnaryOperator;
import org.apache.edgent.function.WrappedFunction;

public class Functions {
    private static final UnaryOperator<Object> IDENTITY = t -> t;
    private static final Function<Object, Integer> ZERO = t -> 0;
    private static final Set<Class<?>> immutableClasses = new HashSet();
    private static final Consumer<Object> DISCARDER;
    private static final Predicate<Object> TRUE;
    private static final Predicate<Object> FALSE;

    public static <T> UnaryOperator<T> identity() {
        return IDENTITY;
    }

    public static <T> Function<T, Integer> zero() {
        return ZERO;
    }

    public static <T> Function<T, Integer> unpartitioned() {
        return Functions.zero();
    }

    public static void closeFunction(Object function) throws Exception {
        AutoCloseable closeable = WrappedFunction.unwrap(AutoCloseable.class, function);
        if (closeable != null) {
            closeable.close();
        }
    }

    public static <T, R> Function<T, R> synchronizedFunction(Function<T, R> function) {
        if (Functions.isImmutable(function) && !(function instanceof AutoCloseable)) {
            return function;
        }
        return new ThreadSafeFunction<T, R>(function);
    }

    public static <T> Supplier<T> synchronizedSupplier(Supplier<T> function) {
        if (Functions.isImmutable(function) && !(function instanceof AutoCloseable)) {
            return function;
        }
        return new ThreadSafeSupplier<T>(function);
    }

    public static <T> Consumer<T> synchronizedConsumer(Consumer<T> function) {
        if (Functions.isImmutable(function) && !(function instanceof AutoCloseable)) {
            return function;
        }
        return new ThreadSafeConsumer<T>(function);
    }

    public static <T, U, R> BiFunction<T, U, R> synchronizedBiFunction(BiFunction<T, U, R> function) {
        if (Functions.isImmutable(function) && !(function instanceof AutoCloseable)) {
            return function;
        }
        return new ThreadSafeBiFunction<T, U, R>(function);
    }

    public static boolean isImmutable(Object function) {
        return Functions.isImmutableClass(function.getClass());
    }

    public static boolean isImmutableClass(Class<?> clazz) {
        do {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                if (!Modifier.isFinal(field.getModifiers())) {
                    return false;
                }
                if (field.getType().isPrimitive() || immutableClasses.contains(field.getType()) || field.getType().isEnum() && Functions.isImmutable(field.getType())) continue;
                return false;
            }
        } while (!Object.class.equals(clazz = clazz.getSuperclass()));
        return true;
    }

    public static <T> Runnable delayedConsume(Consumer<T> consumer, T value) {
        return () -> consumer.accept(value);
    }

    public static Runnable runWithFinal(Runnable action, Runnable finalAction) {
        return () -> {
            try {
                action.run();
            }
            finally {
                finalAction.run();
            }
        };
    }

    public static <T> Consumer<T> discard() {
        return DISCARDER;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return FALSE;
    }

    static {
        immutableClasses.add(String.class);
        immutableClasses.add(Boolean.class);
        immutableClasses.add(Byte.class);
        immutableClasses.add(Short.class);
        immutableClasses.add(Integer.class);
        immutableClasses.add(Long.class);
        immutableClasses.add(BigInteger.class);
        immutableClasses.add(BigDecimal.class);
        immutableClasses.add(Float.class);
        immutableClasses.add(Double.class);
        immutableClasses.add(File.class);
        immutableClasses.add(Character.class);
        immutableClasses.add(Locale.class);
        immutableClasses.add(UUID.class);
        DISCARDER = t -> {};
        TRUE = t -> true;
        FALSE = t -> false;
    }

    private static class ThreadSafeBiFunction<T, U, R>
    extends WrappedFunction<BiFunction<T, U, R>>
    implements BiFunction<T, U, R> {
        private static final long serialVersionUID = 1L;

        ThreadSafeBiFunction(BiFunction<T, U, R> function) {
            super(function);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R apply(T t, U u) {
            BiFunction function;
            BiFunction biFunction = function = (BiFunction)this.f();
            synchronized (biFunction) {
                return function.apply(t, u);
            }
        }
    }

    private static class ThreadSafeConsumer<T>
    extends WrappedFunction<Consumer<T>>
    implements Consumer<T> {
        private static final long serialVersionUID = 1L;

        ThreadSafeConsumer(Consumer<T> function) {
            super(function);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(T value) {
            Consumer function;
            Consumer consumer = function = (Consumer)this.f();
            synchronized (consumer) {
                function.accept(value);
            }
        }
    }

    private static class ThreadSafeSupplier<T>
    extends WrappedFunction<Supplier<T>>
    implements Supplier<T> {
        private static final long serialVersionUID = 1L;

        ThreadSafeSupplier(Supplier<T> function) {
            super(function);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            Supplier function;
            Supplier supplier = function = (Supplier)this.f();
            synchronized (supplier) {
                return function.get();
            }
        }
    }

    private static class ThreadSafeFunction<T, R>
    extends WrappedFunction<Function<T, R>>
    implements Function<T, R> {
        private static final long serialVersionUID = 1L;

        ThreadSafeFunction(Function<T, R> function) {
            super(function);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public R apply(T value) {
            Function function;
            Function function2 = function = (Function)this.f();
            synchronized (function2) {
                return function.apply(value);
            }
        }
    }
}

