/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.execution.services;

import java.lang.reflect.Method;

public class Controls {
    public static final int JOB_HOLD_AFTER_CLOSE_SECS = 10;

    public static boolean isControlServiceMBean(Class<?> controlInterface) {
        if (!controlInterface.isInterface()) {
            return false;
        }
        if (controlInterface.getInterfaces().length != 0) {
            return false;
        }
        if (controlInterface.getTypeParameters().length != 0) {
            return false;
        }
        for (Method cim : controlInterface.getDeclaredMethods()) {
            if (cim.getReturnType() != Void.TYPE && !Controls.validType(cim.getReturnType())) {
                return false;
            }
            for (Class<?> ptt : cim.getParameterTypes()) {
                if (Controls.validType(ptt)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean validType(Class<?> type) {
        if (String.class == type) {
            return true;
        }
        if (Boolean.TYPE == type) {
            return true;
        }
        if (Integer.TYPE == type) {
            return true;
        }
        if (Long.TYPE == type) {
            return true;
        }
        if (Double.TYPE == type) {
            return true;
        }
        return type.isEnum();
    }
}

