/*
 * Decompiled with CFR 0.152.
 */
package org.apache.edgent.analytics.math3.stat;

import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.apache.edgent.analytics.math3.UnivariateAggregate;
import org.apache.edgent.analytics.math3.UnivariateAggregator;
import org.apache.edgent.analytics.math3.stat.Regression2;

class OLS
implements UnivariateAggregator {
    private final Regression2 type;
    private final OLSMultipleLinearRegression ols = new OLSMultipleLinearRegression();
    private double[] values;
    private int yOffset;

    OLS(Regression2 type) {
        this.type = type;
    }

    @Override
    public UnivariateAggregate getAggregate() {
        return this.type;
    }

    @Override
    public void clear(int n) {
        this.values = new double[n * 2];
        this.yOffset = 0;
    }

    @Override
    public void increment(double v) {
        this.values[this.yOffset] = v;
        this.yOffset += 2;
    }

    void setSampleData() {
        for (int x = 0; x < this.values.length / 2; ++x) {
            this.values[x * 2 + 1] = x;
        }
        this.ols.newSampleData(this.values, this.values.length / 2, 1);
    }

    @Override
    public double getResult() {
        if (this.values.length <= 2) {
            return Double.NaN;
        }
        this.setSampleData();
        double[] regressionParams = this.ols.estimateRegressionParameters();
        if (regressionParams.length >= 2) {
            double slope = regressionParams[1];
            return slope;
        }
        return Double.NaN;
    }
}

