/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.tracing.exporter.zipkin;

import brave.handler.SpanHandler;
import org.apache.dubbo.config.nested.ExporterConfig;
import org.apache.dubbo.rpc.model.ApplicationModel;
import zipkin2.Span;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.SpanBytesEncoder;
import zipkin2.reporter.urlconnection.URLConnectionSender;

public class ZipkinSpanHandler {
    public static SpanHandler getSpanHandler(ApplicationModel applicationModel, ExporterConfig.ZipkinConfig zipkinConfig) {
        URLConnectionSender sender = (URLConnectionSender)applicationModel.getBeanFactory().getBean(URLConnectionSender.class);
        if (sender == null) {
            URLConnectionSender.Builder builder = URLConnectionSender.newBuilder();
            builder.connectTimeout((int)zipkinConfig.getConnectTimeout().toMillis());
            builder.readTimeout((int)zipkinConfig.getReadTimeout().toMillis());
            builder.endpoint(zipkinConfig.getEndpoint());
            sender = builder.build();
        }
        BytesEncoder<Span> spanBytesEncoder = ZipkinSpanHandler.getSpanBytesEncoder(applicationModel);
        AsyncReporter spanReporter = AsyncReporter.builder((Sender)sender).build(spanBytesEncoder);
        return zipkin2.reporter.brave.ZipkinSpanHandler.newBuilder((Reporter)spanReporter).build();
    }

    private static BytesEncoder<Span> getSpanBytesEncoder(ApplicationModel applicationModel) {
        BytesEncoder encoder = (BytesEncoder)applicationModel.getBeanFactory().getBean(BytesEncoder.class);
        return encoder == null ? SpanBytesEncoder.JSON_V2 : encoder;
    }
}

