/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.tracing.tracer.otel;

import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.otel.bridge.CompositeSpanExporter;
import io.micrometer.tracing.otel.bridge.EventListener;
import io.micrometer.tracing.otel.bridge.EventPublishingContextWrapper;
import io.micrometer.tracing.otel.bridge.OtelBaggageManager;
import io.micrometer.tracing.otel.bridge.OtelCurrentTraceContext;
import io.micrometer.tracing.otel.bridge.OtelTracer;
import io.micrometer.tracing.otel.bridge.Slf4JBaggageEventListener;
import io.micrometer.tracing.otel.bridge.Slf4JEventListener;
import io.micrometer.tracing.otel.propagation.BaggageTextMapPropagator;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.lang.Nullable;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.TracingConfig;
import org.apache.dubbo.config.nested.BaggageConfig;
import org.apache.dubbo.config.nested.ExporterConfig;
import org.apache.dubbo.config.nested.PropagationConfig;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.tracing.exporter.otlp.OTlpSpanExporter;
import org.apache.dubbo.tracing.exporter.zipkin.ZipkinSpanExporter;
import org.apache.dubbo.tracing.tracer.TracerProvider;
import org.apache.dubbo.tracing.tracer.otel.OTelPropagatorProvider;
import org.apache.dubbo.tracing.utils.PropagationType;

public class OpenTelemetryProvider
implements TracerProvider {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(OpenTelemetryProvider.class);
    private final ApplicationModel applicationModel;
    private final TracingConfig tracingConfig;
    private OTelEventPublisher publisher;
    private OtelCurrentTraceContext otelCurrentTraceContext;

    public OpenTelemetryProvider(ApplicationModel applicationModel, TracingConfig tracingConfig) {
        this.applicationModel = applicationModel;
        this.tracingConfig = tracingConfig;
    }

    @Override
    public Tracer getTracer() {
        List<SpanExporter> spanExporters = this.getSpanExporters();
        String applicationName = this.applicationModel.getApplicationConfigManager().getApplication().map(ApplicationConfig::getName).orElse("dubbo-application");
        this.publisher = new OTelEventPublisher(this.getEventListeners());
        this.otelCurrentTraceContext = this.createCurrentTraceContext();
        String RESOURCE_ATTRIBUTES_CLASS_NAME = "io.opentelemetry.semconv.ResourceAttributes";
        boolean isLowVersion = !ClassUtils.isPresent((String)RESOURCE_ATTRIBUTES_CLASS_NAME, (ClassLoader)Thread.currentThread().getContextClassLoader());
        AttributeKey serviceNameAttributeKey = AttributeKey.stringKey((String)"service.name");
        String SERVICE_NAME = "SERVICE_NAME";
        if (isLowVersion) {
            RESOURCE_ATTRIBUTES_CLASS_NAME = "io.opentelemetry.semconv.resource.attributes.ResourceAttributes";
        }
        try {
            serviceNameAttributeKey = (AttributeKey)ClassUtils.resolveClass((String)RESOURCE_ATTRIBUTES_CLASS_NAME, (ClassLoader)Thread.currentThread().getContextClassLoader()).getDeclaredField(SERVICE_NAME).get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SdkTracerProvider sdkTracerProvider = SdkTracerProvider.builder().setSampler(this.getSampler()).setResource(Resource.create((Attributes)Attributes.of((AttributeKey)serviceNameAttributeKey, (Object)applicationName))).addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)new CompositeSpanExporter(spanExporters, null, null, null)).build()).build();
        ContextPropagators otelContextPropagators = this.createOtelContextPropagators();
        OpenTelemetrySdk openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(otelContextPropagators).build();
        io.opentelemetry.api.trace.Tracer otelTracer = openTelemetrySdk.getTracerProvider().get("org.apache.dubbo", Version.getVersion());
        OTelPropagatorProvider.createMicrometerPropagator(otelContextPropagators, otelTracer);
        return new OtelTracer(otelTracer, this.otelCurrentTraceContext, (OtelTracer.EventPublisher)this.publisher, (BaggageManager)new OtelBaggageManager((CurrentTraceContext)this.otelCurrentTraceContext, this.tracingConfig.getBaggage().getRemoteFields(), Collections.emptyList()));
    }

    private List<SpanExporter> getSpanExporters() {
        ExporterConfig exporterConfig = this.tracingConfig.getTracingExporter();
        ExporterConfig.ZipkinConfig zipkinConfig = exporterConfig.getZipkinConfig();
        ExporterConfig.OtlpConfig otlpConfig = exporterConfig.getOtlpConfig();
        ArrayList<SpanExporter> res = new ArrayList<SpanExporter>();
        if (zipkinConfig != null && StringUtils.isNotEmpty((String)zipkinConfig.getEndpoint())) {
            LOGGER.info("Create zipkin span exporter.");
            res.add(ZipkinSpanExporter.getSpanExporter(this.applicationModel, zipkinConfig));
        }
        if (otlpConfig != null && StringUtils.isNotEmpty((String)otlpConfig.getEndpoint())) {
            LOGGER.info("Create OTlp span exporter.");
            res.add(OTlpSpanExporter.getSpanExporter(this.applicationModel, otlpConfig));
        }
        return res;
    }

    private Sampler getSampler() {
        Sampler rootSampler = Sampler.traceIdRatioBased((double)this.tracingConfig.getSampling().getProbability());
        return Sampler.parentBased((Sampler)rootSampler);
    }

    private List<EventListener> getEventListeners() {
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        Slf4JEventListener slf4JEventListener = new Slf4JEventListener();
        listeners.add((EventListener)slf4JEventListener);
        if (this.tracingConfig.getBaggage().getEnabled().booleanValue()) {
            Slf4JBaggageEventListener slf4JBaggageEventListener = new Slf4JBaggageEventListener(this.tracingConfig.getBaggage().getCorrelation().getFields());
            listeners.add((EventListener)slf4JBaggageEventListener);
        }
        return listeners;
    }

    private OtelCurrentTraceContext createCurrentTraceContext() {
        ContextStorage.addWrapper((Function)new EventPublishingContextWrapper((OtelTracer.EventPublisher)this.publisher));
        return new OtelCurrentTraceContext();
    }

    private ContextPropagators createOtelContextPropagators() {
        return ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{PropagatorFactory.getPropagator(this.tracingConfig.getPropagation(), this.tracingConfig.getBaggage(), this.otelCurrentTraceContext)}));
    }

    static class OTelEventPublisher
    implements OtelTracer.EventPublisher {
        private final List<EventListener> listeners;

        OTelEventPublisher(List<EventListener> listeners) {
            this.listeners = listeners;
        }

        public void publishEvent(Object event) {
            for (EventListener listener : this.listeners) {
                listener.onEvent(event);
            }
        }
    }

    static class PropagatorFactory {
        PropagatorFactory() {
        }

        public static TextMapPropagator getPropagator(PropagationConfig propagationConfig, @Nullable BaggageConfig baggageConfig, @Nullable OtelCurrentTraceContext currentTraceContext) {
            if (baggageConfig == null || !baggageConfig.getEnabled().booleanValue()) {
                return PropagatorFactory.getPropagatorWithoutBaggage(propagationConfig);
            }
            return PropagatorFactory.getPropagatorWithBaggage(propagationConfig, baggageConfig, currentTraceContext);
        }

        private static TextMapPropagator getPropagatorWithoutBaggage(PropagationConfig propagationConfig) {
            String type = propagationConfig.getType();
            PropagationType propagationType = PropagationType.forValue(type);
            if (PropagationType.B3 == propagationType) {
                return B3Propagator.injectingSingleHeader();
            }
            if (PropagationType.W3C == propagationType) {
                return W3CTraceContextPropagator.getInstance();
            }
            return TextMapPropagator.noop();
        }

        private static TextMapPropagator getPropagatorWithBaggage(PropagationConfig propagationConfig, BaggageConfig baggageConfig, OtelCurrentTraceContext currentTraceContext) {
            String type = propagationConfig.getType();
            PropagationType propagationType = PropagationType.forValue(type);
            if (PropagationType.B3 == propagationType) {
                List remoteFields = baggageConfig.getRemoteFields();
                return TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{B3Propagator.injectingSingleHeader(), new BaggageTextMapPropagator(remoteFields, (BaggageManager)new OtelBaggageManager((CurrentTraceContext)currentTraceContext, remoteFields, Collections.emptyList()))});
            }
            if (PropagationType.W3C == propagationType) {
                List remoteFields = baggageConfig.getRemoteFields();
                return TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{W3CTraceContextPropagator.getInstance(), W3CBaggagePropagator.getInstance(), new BaggageTextMapPropagator(remoteFields, (BaggageManager)new OtelBaggageManager((CurrentTraceContext)currentTraceContext, remoteFields, Collections.emptyList()))});
            }
            return TextMapPropagator.noop();
        }
    }
}

