/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.tracing.tracer.brave;

import brave.Tracer;
import brave.Tracing;
import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import brave.baggage.BaggagePropagationCustomizer;
import brave.baggage.CorrelationScopeConfig;
import brave.baggage.CorrelationScopeCustomizer;
import brave.baggage.CorrelationScopeDecorator;
import brave.context.slf4j.MDCScopeDecorator;
import brave.handler.SpanHandler;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.sampler.Sampler;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.brave.bridge.BraveBaggageManager;
import io.micrometer.tracing.brave.bridge.BraveCurrentTraceContext;
import io.micrometer.tracing.brave.bridge.BraveTracer;
import io.micrometer.tracing.brave.bridge.W3CPropagation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.TracingConfig;
import org.apache.dubbo.config.nested.BaggageConfig;
import org.apache.dubbo.config.nested.ExporterConfig;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.tracing.exporter.zipkin.ZipkinSpanHandler;
import org.apache.dubbo.tracing.tracer.TracerProvider;
import org.apache.dubbo.tracing.tracer.brave.BravePropagatorProvider;
import org.apache.dubbo.tracing.utils.ObservationSupportUtil;
import org.apache.dubbo.tracing.utils.PropagationType;

public class BraveProvider
implements TracerProvider {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(BraveProvider.class);
    private static final BraveBaggageManager BRAVE_BAGGAGE_MANAGER = new BraveBaggageManager();
    private final ApplicationModel applicationModel;
    private final TracingConfig tracingConfig;

    public BraveProvider(ApplicationModel applicationModel, TracingConfig tracingConfig) {
        this.applicationModel = applicationModel;
        this.tracingConfig = tracingConfig;
    }

    @Override
    public io.micrometer.tracing.Tracer getTracer() {
        List<SpanHandler> spanHandlerList = this.getSpanHandlers();
        String applicationName = this.applicationModel.getApplicationConfigManager().getApplication().map(ApplicationConfig::getName).orElse("dubbo-application");
        ThreadLocalCurrentTraceContext braveCurrentTraceContext = ThreadLocalCurrentTraceContext.newBuilder().addScopeDecorator(this.correlationScopeDecorator()).build();
        BraveCurrentTraceContext bridgeContext = new BraveCurrentTraceContext((brave.propagation.CurrentTraceContext)braveCurrentTraceContext);
        Tracing.Builder builder = Tracing.newBuilder().currentTraceContext((brave.propagation.CurrentTraceContext)braveCurrentTraceContext).supportsJoin(false).traceId128Bit(true).localServiceName(applicationName).propagationFactory(PropagatorFactory.getPropagationFactory(this.tracingConfig)).sampler(this.getSampler());
        spanHandlerList.forEach(arg_0 -> ((Tracing.Builder)builder).addSpanHandler(arg_0));
        Tracing tracing = builder.build();
        BravePropagatorProvider.createMicrometerPropagator(tracing);
        Tracer braveTracer = tracing.tracer();
        return new BraveTracer(braveTracer, (CurrentTraceContext)bridgeContext, (BaggageManager)BRAVE_BAGGAGE_MANAGER);
    }

    private List<SpanHandler> getSpanHandlers() {
        ExporterConfig exporterConfig = this.tracingConfig.getTracingExporter();
        ArrayList<SpanHandler> res = new ArrayList<SpanHandler>();
        if (!ObservationSupportUtil.isSupportBraveURLSender()) {
            return res;
        }
        ExporterConfig.ZipkinConfig zipkinConfig = exporterConfig.getZipkinConfig();
        if (zipkinConfig != null && StringUtils.isNotEmpty((String)zipkinConfig.getEndpoint())) {
            LOGGER.info("Create zipkin span handler.");
            res.add(ZipkinSpanHandler.getSpanHandler(this.applicationModel, zipkinConfig));
        }
        return res;
    }

    private Sampler getSampler() {
        return Sampler.create((float)this.tracingConfig.getSampling().getProbability());
    }

    private Optional<CorrelationScopeCustomizer> correlationFieldsCorrelationScopeCustomizer() {
        BaggageConfig.Correlation correlation = this.tracingConfig.getBaggage().getCorrelation();
        boolean enabled = correlation.isEnabled();
        if (!enabled) {
            return Optional.empty();
        }
        return Optional.of(builder -> {
            List correlationFields = correlation.getFields();
            for (String field : correlationFields) {
                builder.add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.newBuilder((BaggageField)BaggageField.create((String)field)).flushOnUpdate().build());
            }
        });
    }

    private CurrentTraceContext.ScopeDecorator correlationScopeDecorator() {
        CorrelationScopeDecorator.Builder builder = MDCScopeDecorator.newBuilder();
        this.correlationFieldsCorrelationScopeCustomizer().ifPresent(customizer -> customizer.customize(builder));
        return builder.build();
    }

    static class PropagatorFactory {
        PropagatorFactory() {
        }

        public static Propagation.Factory getPropagationFactory(TracingConfig tracingConfig) {
            BaggageConfig baggageConfig = tracingConfig.getBaggage();
            if (baggageConfig == null || !baggageConfig.getEnabled().booleanValue()) {
                return PropagatorFactory.getPropagationFactoryWithoutBaggage(tracingConfig);
            }
            return PropagatorFactory.getPropagationFactoryWithBaggage(tracingConfig);
        }

        private static Propagation.Factory getPropagationFactoryWithoutBaggage(TracingConfig tracingConfig) {
            PropagationType propagationType = PropagationType.forValue(tracingConfig.getPropagation().getType());
            if (PropagationType.W3C == propagationType) {
                return new W3CPropagation();
            }
            return B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE_NO_PARENT).build();
        }

        private static Propagation.Factory getPropagationFactoryWithBaggage(TracingConfig tracingConfig) {
            PropagationType propagationType = PropagationType.forValue(tracingConfig.getPropagation().getType());
            Object delegate = PropagationType.W3C == propagationType ? new W3CPropagation((BaggageManager)BRAVE_BAGGAGE_MANAGER, Collections.emptyList()) : B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE_NO_PARENT).build();
            return PropagatorFactory.getBaggageFactoryBuilder(delegate, tracingConfig).build();
        }

        private static BaggagePropagation.FactoryBuilder getBaggageFactoryBuilder(Propagation.Factory delegate, TracingConfig tracingConfig) {
            BaggagePropagation.FactoryBuilder builder = BaggagePropagation.newFactoryBuilder((Propagation.Factory)delegate);
            PropagatorFactory.getBaggagePropagationCustomizers(tracingConfig).forEach(customizer -> customizer.customize(builder));
            return builder;
        }

        private static List<BaggagePropagationCustomizer> getBaggagePropagationCustomizers(TracingConfig tracingConfig) {
            ArrayList<BaggagePropagationCustomizer> res = new ArrayList<BaggagePropagationCustomizer>();
            if (tracingConfig.getBaggage().getCorrelation().isEnabled()) {
                res.add(PropagatorFactory.remoteFieldsBaggagePropagationCustomizer(tracingConfig));
            }
            return res;
        }

        private static BaggagePropagationCustomizer remoteFieldsBaggagePropagationCustomizer(TracingConfig tracingConfig) {
            return builder -> {
                List remoteFields = tracingConfig.getBaggage().getRemoteFields();
                for (String fieldName : remoteFields) {
                    builder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.remote((BaggageField)BaggageField.create((String)fieldName)));
                }
            };
        }
    }
}

