/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.context.event;

import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;

@Order(value=-2147483628)
public class DubboNetInterfaceConfigApplicationListener
implements ApplicationListener<ApplicationContextInitializedEvent> {
    public void onApplicationEvent(ApplicationContextInitializedEvent event) {
        String ignoredNetworkInterface;
        ConfigurableEnvironment environment = event.getApplicationContext().getEnvironment();
        String preferredNetworkInterface = System.getProperty("dubbo.network.interface.preferred");
        if (StringUtils.isBlank((CharSequence)preferredNetworkInterface) && StringUtils.isNotBlank((CharSequence)(preferredNetworkInterface = environment.getProperty("dubbo.network.interface.preferred")))) {
            System.setProperty("dubbo.network.interface.preferred", preferredNetworkInterface);
        }
        if (StringUtils.isBlank((CharSequence)(ignoredNetworkInterface = System.getProperty("dubbo.network.interface.ignored"))) && StringUtils.isNotBlank((CharSequence)(ignoredNetworkInterface = environment.getProperty("dubbo.network.interface.ignored")))) {
            System.setProperty("dubbo.network.interface.ignored", ignoredNetworkInterface);
        }
    }
}

