/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.beans.factory.config;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.dubbo.config.ServiceConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ClassUtils;

public class ServiceBeanIdConflictProcessor
implements MergedBeanDefinitionPostProcessor,
DisposableBean,
PriorityOrdered {
    private Map<String, String> interfaceNamesToBeanNames = new HashMap<String, String>();
    private Set<String> conflictedBeanNames = new LinkedHashSet<String>();

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        String interfaceName;
        String mappedBeanName;
        Class rawBeanType = ClassUtils.getUserClass(beanType);
        if (ClassUtils.isAssignable(ServiceConfig.class, (Class)rawBeanType) && (mappedBeanName = this.interfaceNamesToBeanNames.putIfAbsent(interfaceName = (String)beanDefinition.getPropertyValues().get("interface"), beanName)) != null && !mappedBeanName.equals(beanName)) {
            this.conflictedBeanNames.add(beanName);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ServiceConfig serviceConfig;
        if (this.conflictedBeanNames.contains(beanName) && bean instanceof ServiceConfig && this.isConflictedServiceConfig(serviceConfig = (ServiceConfig)bean)) {
            serviceConfig.setId(beanName);
        }
        return bean;
    }

    private boolean isConflictedServiceConfig(ServiceConfig serviceConfig) {
        return Objects.equals(serviceConfig.getId(), serviceConfig.getInterface());
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void destroy() throws Exception {
        this.interfaceNamesToBeanNames.clear();
        this.conflictedBeanNames.clear();
    }
}

