/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.actuate.endpoint.metadata;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.spring.boot.actuate.endpoint.metadata.AbstractDubboMetadata;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class DubboConfigsMetadata
extends AbstractDubboMetadata {
    public Map<String, Map<String, Map<String, Object>>> configs() {
        LinkedHashMap<String, Map<String, Map<String, Object>>> configsMap = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
        this.addDubboConfigBeans(ApplicationConfig.class, configsMap);
        this.addDubboConfigBeans(ConsumerConfig.class, configsMap);
        this.addDubboConfigBeans(MethodConfig.class, configsMap);
        this.addDubboConfigBeans(ModuleConfig.class, configsMap);
        this.addDubboConfigBeans(MonitorConfig.class, configsMap);
        this.addDubboConfigBeans(ProtocolConfig.class, configsMap);
        this.addDubboConfigBeans(ProviderConfig.class, configsMap);
        this.addDubboConfigBeans(ReferenceConfig.class, configsMap);
        this.addDubboConfigBeans(RegistryConfig.class, configsMap);
        this.addDubboConfigBeans(ServiceConfig.class, configsMap);
        return configsMap;
    }

    private void addDubboConfigBeans(Class<? extends AbstractConfig> dubboConfigClass, Map<String, Map<String, Map<String, Object>>> configsMap) {
        Map dubboConfigBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, dubboConfigClass);
        String name = dubboConfigClass.getSimpleName();
        TreeMap<String, Map<String, Object>> beansMetadata = new TreeMap<String, Map<String, Object>>();
        for (Map.Entry entry : dubboConfigBeans.entrySet()) {
            String beanName = (String)entry.getKey();
            AbstractConfig configBean = (AbstractConfig)entry.getValue();
            Map<String, Object> configBeanMeta = this.resolveBeanMetadata(configBean);
            beansMetadata.put(beanName, configBeanMeta);
        }
        configsMap.put(name, beansMetadata);
    }
}

