/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.actuate.endpoint.metadata;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.spring.boot.actuate.endpoint.metadata.AbstractDubboMetadata;
import org.springframework.stereotype.Component;

@Component
public class DubboShutdownMetadata
extends AbstractDubboMetadata {
    public Map<String, Object> shutdown() throws Exception {
        LinkedHashMap<String, Integer> shutdownCountData = new LinkedHashMap<String, Integer>();
        int registriesCount = AbstractRegistryFactory.getRegistries().size();
        int protocolsCount = this.getProtocolConfigsBeanMap().size();
        shutdownCountData.put("registries", registriesCount);
        shutdownCountData.put("protocols", protocolsCount);
        Map<String, ServiceBean> serviceBeansMap = this.getServiceBeansMap();
        if (!serviceBeansMap.isEmpty()) {
            for (ServiceBean serviceBean : serviceBeansMap.values()) {
                serviceBean.destroy();
            }
        }
        shutdownCountData.put("services", serviceBeansMap.size());
        Collection references = ApplicationModel.getConfigManager().getReferences();
        for (ReferenceConfigBase reference : references) {
            reference.destroy();
        }
        shutdownCountData.put("references", references.size());
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("shutdown.count", shutdownCountData);
        return treeMap;
    }
}

