/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.serialize.hessian.dubbo;

import com.caucho.hessian.io.SerializerFactory;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.serialize.hessian.Hessian2SerializerFactory;
import org.apache.dubbo.serialize.hessian.dubbo.AbstractHessian2FactoryInitializer;

public class WhitelistHessian2FactoryInitializer
extends AbstractHessian2FactoryInitializer {
    @Override
    public SerializerFactory createSerializerFactory() {
        Hessian2SerializerFactory serializerFactory = new Hessian2SerializerFactory();
        String whiteList = ConfigurationUtils.getProperty((String)"dubbo.application.hessian2.whitelist");
        if ("true".equals(whiteList)) {
            serializerFactory.getClassFactory().setWhitelist(true);
            String allowPattern = ConfigurationUtils.getProperty((String)"dubbo.application.hessian2.allow");
            if (StringUtils.isNotEmpty((String)allowPattern)) {
                serializerFactory.getClassFactory().allow(allowPattern);
            }
        } else {
            serializerFactory.getClassFactory().setWhitelist(false);
            String denyPattern = ConfigurationUtils.getProperty((String)"dubbo.application.hessian2.deny");
            if (StringUtils.isNotEmpty((String)denyPattern)) {
                serializerFactory.getClassFactory().deny(denyPattern);
            }
        }
        return serializerFactory;
    }
}

