/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.msgpack;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.utils.PojoUtils;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class MsgpackObjectInput
implements ObjectInput {
    private final InputStream in;
    private ObjectMapper om;

    public MsgpackObjectInput(InputStream in) {
        this.in = in;
        this.om = new ObjectMapper((JsonFactory)new MessagePackFactory());
        this.om.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
    }

    public boolean readBool() throws IOException {
        return this.read(Boolean.TYPE);
    }

    public byte readByte() throws IOException {
        return this.read(Byte.TYPE);
    }

    public short readShort() throws IOException {
        return this.read(Short.TYPE);
    }

    public int readInt() throws IOException {
        return this.read(Integer.TYPE);
    }

    public long readLong() throws IOException {
        return this.read(Long.TYPE);
    }

    public float readFloat() throws IOException {
        return this.read(Float.TYPE).floatValue();
    }

    public double readDouble() throws IOException {
        return this.read(Double.TYPE);
    }

    public String readUTF() throws IOException {
        return this.read(String.class);
    }

    public byte[] readBytes() throws IOException {
        return this.read(byte[].class);
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        return this.om.readValue(this.in, Object.class);
    }

    public <T> T readObject(Class<T> cls) throws IOException, ClassNotFoundException {
        return this.read(cls);
    }

    public <T> T readObject(Class<T> cls, Type type) throws IOException, ClassNotFoundException {
        T value = this.readObject(cls);
        return (T)PojoUtils.realize(value, cls, (Type)type);
    }

    private <T> T read(Class<T> cls) throws IOException {
        return (T)this.om.readValue(this.in, cls);
    }

    public Throwable readThrowable() throws IOException, ClassNotFoundException {
        Class clazz = this.readObject(Class.class);
        return (Throwable)this.readObject(clazz);
    }
}

