/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.kryo.optimized;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.Cleanable;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.kryo.utils.KryoUtils;

public class KryoObjectInput2
implements ObjectInput,
Cleanable {
    private Kryo kryo;
    private Input input;

    public KryoObjectInput2(InputStream inputStream) {
        this.input = new Input(inputStream);
        this.kryo = KryoUtils.get();
    }

    public boolean readBool() throws IOException {
        try {
            return this.input.readBoolean();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    public byte readByte() throws IOException {
        try {
            return this.input.readByte();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    public short readShort() throws IOException {
        try {
            return this.input.readShort();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    public int readInt() throws IOException {
        try {
            return this.input.readInt();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    public long readLong() throws IOException {
        try {
            return this.input.readLong();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    public float readFloat() throws IOException {
        try {
            return this.input.readFloat();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    public double readDouble() throws IOException {
        try {
            return this.input.readDouble();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    public byte[] readBytes() throws IOException {
        try {
            int len = this.input.readInt();
            if (len < 0) {
                return null;
            }
            if (len == 0) {
                return new byte[0];
            }
            return this.input.readBytes(len);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    public String readUTF() throws IOException {
        try {
            return this.input.readString();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        try {
            return this.kryo.readObjectOrNull(this.input, String.class);
        }
        catch (KryoException e) {
            throw new UnsupportedOperationException("Kryo serialization must know the input type when deserialize.", e);
        }
    }

    public Throwable readThrowable() throws IOException, ClassNotFoundException {
        return (Throwable)this.kryo.readClassAndObject(this.input);
    }

    public Object readEvent() throws IOException, ClassNotFoundException {
        return this.kryo.readObjectOrNull(this.input, String.class);
    }

    public <T> T readObject(Class<T> clazz) throws IOException, ClassNotFoundException {
        return (T)this.kryo.readObjectOrNull(this.input, clazz);
    }

    public <T> T readObject(Class<T> clazz, Type type) throws IOException, ClassNotFoundException {
        return this.readObject(clazz);
    }

    public void cleanup() {
        KryoUtils.release(this.kryo);
        this.kryo = null;
    }
}

