/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.kryo.utils.ReflectionUtils;

public class CompatibleKryo
extends Kryo {
    private static final Logger logger = LoggerFactory.getLogger(CompatibleKryo.class);

    public Serializer getDefaultSerializer(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (!(ReflectionUtils.isJdk(type) || type.isArray() || type.isEnum() || ReflectionUtils.checkZeroArgConstructor(type))) {
            if (logger.isWarnEnabled()) {
                logger.warn(type + " has no zero-arg constructor and this will affect the serialization performance");
            }
            return new JavaSerializer();
        }
        return super.getDefaultSerializer(type);
    }
}

