/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fastjson2;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderCreatorASM;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterCreatorASM;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.aot.NativeDetector;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeClassLoaderListener;

public class Fastjson2CreatorManager
implements ScopeClassLoaderListener<FrameworkModel> {
    private static final ClassLoader SYSTEM_CLASSLOADER_KEY = new ClassLoader(){};
    private final ConcurrentHashMap<ClassLoader, ObjectReaderCreator> readerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<ClassLoader, ObjectWriterCreator> writerMap = new ConcurrentHashMap();

    public Fastjson2CreatorManager(FrameworkModel frameworkModel) {
        frameworkModel.addClassLoaderListener((ScopeClassLoaderListener)this);
    }

    public void setCreator(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = SYSTEM_CLASSLOADER_KEY;
        }
        if (NativeDetector.inNativeImage()) {
            JSONFactory.setContextReaderCreator((ObjectReaderCreator)this.readerMap.putIfAbsent(classLoader, ObjectReaderCreator.INSTANCE));
            JSONFactory.setContextWriterCreator((ObjectWriterCreator)this.writerMap.putIfAbsent(classLoader, ObjectWriterCreator.INSTANCE));
        } else {
            JSONFactory.setContextReaderCreator((ObjectReaderCreator)((ObjectReaderCreator)ConcurrentHashMapUtils.computeIfAbsent(this.readerMap, (Object)classLoader, ObjectReaderCreatorASM::new)));
            JSONFactory.setContextWriterCreator((ObjectWriterCreator)((ObjectWriterCreator)ConcurrentHashMapUtils.computeIfAbsent(this.writerMap, (Object)classLoader, ObjectWriterCreatorASM::new)));
        }
    }

    public void onAddClassLoader(FrameworkModel scopeModel, ClassLoader classLoader) {
    }

    public void onRemoveClassLoader(FrameworkModel scopeModel, ClassLoader classLoader) {
        this.readerMap.remove(classLoader);
        this.writerMap.remove(classLoader);
    }
}

