/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fastjson2;

import com.alibaba.fastjson2.JSONB;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.serialize.fastjson2.FastJson2ObjectInput;
import org.apache.dubbo.common.serialize.fastjson2.FastJson2ObjectOutput;
import org.apache.dubbo.common.serialize.fastjson2.Fastjson2CreatorManager;
import org.apache.dubbo.common.serialize.fastjson2.Fastjson2SecurityManager;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class FastJson2Serialization
implements Serialization {
    private static final Logger logger = LoggerFactory.getLogger(FastJson2Serialization.class);

    public byte getContentTypeId() {
        return 23;
    }

    public String getContentType() {
        return "text/jsonb";
    }

    public ObjectOutput serialize(URL url, OutputStream output) throws IOException {
        Fastjson2CreatorManager fastjson2CreatorManager = (Fastjson2CreatorManager)Optional.ofNullable(url).map(URL::getOrDefaultFrameworkModel).orElseGet(FrameworkModel::defaultModel).getBeanFactory().getBean(Fastjson2CreatorManager.class);
        Fastjson2SecurityManager fastjson2SecurityManager = (Fastjson2SecurityManager)Optional.ofNullable(url).map(URL::getOrDefaultFrameworkModel).orElseGet(FrameworkModel::defaultModel).getBeanFactory().getBean(Fastjson2SecurityManager.class);
        return new FastJson2ObjectOutput(fastjson2CreatorManager, fastjson2SecurityManager, output);
    }

    public ObjectInput deserialize(URL url, InputStream input) throws IOException {
        Fastjson2CreatorManager fastjson2CreatorManager = (Fastjson2CreatorManager)Optional.ofNullable(url).map(URL::getOrDefaultFrameworkModel).orElseGet(FrameworkModel::defaultModel).getBeanFactory().getBean(Fastjson2CreatorManager.class);
        Fastjson2SecurityManager fastjson2SecurityManager = (Fastjson2SecurityManager)Optional.ofNullable(url).map(URL::getOrDefaultFrameworkModel).orElseGet(FrameworkModel::defaultModel).getBeanFactory().getBean(Fastjson2SecurityManager.class);
        return new FastJson2ObjectInput(fastjson2CreatorManager, fastjson2SecurityManager, input);
    }

    static {
        Class<JSONB> aClass = null;
        try {
            aClass = JSONB.class;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (aClass == null) {
            logger.info("Failed to load com.alibaba.fastjson2.JSONB, fastjson2 serialization will be disabled.");
            throw new IllegalStateException("The fastjson2 is not in classpath.");
        }
    }
}

