/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.proxy.wrapper;

import java.lang.reflect.Constructor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.bytecode.Wrapper;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.service.GenericService;

public class StubProxyFactoryWrapper
implements ProxyFactory {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(StubProxyFactoryWrapper.class);
    private final ProxyFactory proxyFactory;
    private Protocol protocol;

    public StubProxyFactoryWrapper(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public <T> T getProxy(Invoker<T> invoker, boolean generic) throws RpcException {
        URL url;
        String stub;
        T proxy = this.proxyFactory.getProxy(invoker, generic);
        if (GenericService.class != invoker.getInterface() && ConfigUtils.isNotEmpty((String)(stub = (url = invoker.getUrl()).getParameter("stub", url.getParameter("local"))))) {
            Class<T> serviceType = invoker.getInterface();
            if (ConfigUtils.isDefault((String)stub)) {
                stub = url.hasParameter("stub") ? serviceType.getName() + "Stub" : serviceType.getName() + "Local";
            }
            try {
                Class stubClass = ReflectUtils.forName((String)stub);
                if (!serviceType.isAssignableFrom(stubClass)) {
                    throw new IllegalStateException("The stub implementation class " + stubClass.getName() + " not implement interface " + serviceType.getName());
                }
                try {
                    Constructor constructor = ReflectUtils.findConstructor((Class)stubClass, serviceType);
                    proxy = constructor.newInstance(proxy);
                    URLBuilder urlBuilder = URLBuilder.from((URL)url);
                    if (url.getParameter("dubbo.stub.event", false)) {
                        urlBuilder.addParameter("dubbo.stub.event.methods", StringUtils.join((String[])Wrapper.getWrapper(proxy.getClass()).getDeclaredMethodNames(), (String)","));
                        urlBuilder.addParameter("isserver", Boolean.FALSE.toString());
                        try {
                            this.export(proxy, invoker.getInterface(), (URL)urlBuilder.build());
                        }
                        catch (Exception e) {
                            LOGGER.error("3-2", "", "", "export a stub service error.", (Throwable)e);
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("No such constructor \"public " + stubClass.getSimpleName() + "(" + serviceType.getName() + ")\" in stub implementation class " + stubClass.getName(), e);
                }
            }
            catch (Throwable t) {
                LOGGER.error("3-2", "", "", "Failed to create stub implementation class " + stub + " in consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", cause: " + t.getMessage(), t);
            }
        }
        return proxy;
    }

    @Override
    public <T> T getProxy(Invoker<T> invoker) throws RpcException {
        return this.getProxy(invoker, false);
    }

    @Override
    public <T> Invoker<T> getInvoker(T proxy, Class<T> type, URL url) throws RpcException {
        return this.proxyFactory.getInvoker(proxy, type, url);
    }

    private <T> Exporter<T> export(T instance, Class<T> type, URL url) {
        return this.protocol.export(this.proxyFactory.getInvoker(instance, type, url));
    }
}

