/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.AttachmentsAdapter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceRepository;
import org.apache.dubbo.rpc.support.RpcUtils;

public class RpcInvocation
implements Invocation,
Serializable {
    private static final long serialVersionUID = -4355285085441097045L;
    private String targetServiceUniqueName;
    private String protocolServiceKey;
    private String methodName;
    private String serviceName;
    private transient Class<?>[] parameterTypes;
    private String parameterTypesDesc;
    private String[] compatibleParamSignatures;
    private Object[] arguments;
    private Map<String, Object> attachments;
    private transient Map<Object, Object> attributes = new LinkedHashMap<Object, Object>();
    private transient Invoker<?> invoker;
    private transient Class<?> returnType;
    private transient Type[] returnTypes;
    private transient InvokeMode invokeMode;

    public RpcInvocation() {
    }

    public RpcInvocation(Invocation invocation, Invoker<?> invoker) {
        this(invocation.getMethodName(), invocation.getServiceName(), invocation.getProtocolServiceKey(), invocation.getParameterTypes(), invocation.getArguments(), new LinkedHashMap<String, Object>(invocation.getObjectAttachments()), invocation.getInvoker(), invocation.getAttributes());
        if (invoker != null) {
            URL url = invoker.getUrl();
            this.setAttachment("path", url.getPath());
            if (url.hasParameter("interface")) {
                this.setAttachment("interface", url.getParameter("interface"));
            }
            if (url.hasParameter("group")) {
                this.setAttachment("group", url.getGroup());
            }
            if (url.hasParameter("version")) {
                this.setAttachment("version", url.getVersion("0.0.0"));
            }
            if (url.hasParameter("timeout")) {
                this.setAttachment("timeout", url.getParameter("timeout"));
            }
            if (url.hasParameter("token")) {
                this.setAttachment("token", url.getParameter("token"));
            }
            if (url.hasParameter("application")) {
                this.setAttachment("application", url.getApplication());
            }
        }
        this.targetServiceUniqueName = invocation.getTargetServiceUniqueName();
        this.protocolServiceKey = invocation.getProtocolServiceKey();
    }

    public RpcInvocation(Invocation invocation) {
        this(invocation.getMethodName(), invocation.getServiceName(), invocation.getProtocolServiceKey(), invocation.getParameterTypes(), invocation.getArguments(), invocation.getObjectAttachments(), invocation.getInvoker(), invocation.getAttributes());
        this.targetServiceUniqueName = invocation.getTargetServiceUniqueName();
    }

    public RpcInvocation(Method method, String serviceName, String protocolServiceKey, Object[] arguments) {
        this(method, serviceName, protocolServiceKey, arguments, null, null);
    }

    public RpcInvocation(Method method, String serviceName, String protocolServiceKey, Object[] arguments, Map<String, Object> attachment, Map<Object, Object> attributes) {
        this(method.getName(), serviceName, protocolServiceKey, method.getParameterTypes(), arguments, attachment, null, attributes);
    }

    public RpcInvocation(String methodName, String serviceName, String protocolServiceKey, Class<?>[] parameterTypes, Object[] arguments) {
        this(methodName, serviceName, protocolServiceKey, parameterTypes, arguments, null, null, null);
    }

    public RpcInvocation(String methodName, String serviceName, String protocolServiceKey, Class<?>[] parameterTypes, Object[] arguments, Map<String, Object> attachments) {
        this(methodName, serviceName, protocolServiceKey, parameterTypes, arguments, attachments, null, null);
    }

    public RpcInvocation(String methodName, String serviceName, String protocolServiceKey, Class<?>[] parameterTypes, Object[] arguments, Map<String, Object> attachments, Invoker<?> invoker, Map<Object, Object> attributes) {
        this.methodName = methodName;
        this.serviceName = serviceName;
        this.protocolServiceKey = protocolServiceKey;
        this.parameterTypes = parameterTypes == null ? new Class[]{} : parameterTypes;
        this.arguments = arguments == null ? new Object[]{} : arguments;
        this.attachments = attachments == null ? new LinkedHashMap() : attachments;
        this.attributes = attributes == null ? new LinkedHashMap() : attributes;
        this.invoker = invoker;
        this.initParameterDesc();
    }

    private void initParameterDesc() {
        MethodDescriptor methodDescriptor;
        ServiceDescriptor serviceDescriptor;
        ServiceRepository repository = ApplicationModel.getServiceRepository();
        if (StringUtils.isNotEmpty((String)this.serviceName) && (serviceDescriptor = repository.lookupService(this.serviceName)) != null && (methodDescriptor = serviceDescriptor.getMethod(this.methodName, (Class[])this.parameterTypes)) != null) {
            this.parameterTypesDesc = methodDescriptor.getParamDesc();
            this.compatibleParamSignatures = methodDescriptor.getCompatibleParamSignatures();
            this.returnTypes = methodDescriptor.getReturnTypes();
            this.returnType = methodDescriptor.getReturnClass();
        }
        if (this.parameterTypesDesc == null) {
            this.parameterTypesDesc = ReflectUtils.getDesc((Class[])this.getParameterTypes());
            this.compatibleParamSignatures = (String[])Stream.of(this.parameterTypes).map(Class::getName).toArray(String[]::new);
            this.returnTypes = RpcUtils.getReturnTypes(this);
            this.returnType = RpcUtils.getReturnType(this);
        }
    }

    @Override
    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker<?> invoker) {
        this.invoker = invoker;
    }

    @Override
    public Object put(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    @Override
    public Object get(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getTargetServiceUniqueName() {
        return this.targetServiceUniqueName;
    }

    public void setTargetServiceUniqueName(String targetServiceUniqueName) {
        this.targetServiceUniqueName = targetServiceUniqueName;
    }

    @Override
    public String getProtocolServiceKey() {
        return this.protocolServiceKey;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes == null ? new Class[]{} : parameterTypes;
    }

    public String getParameterTypesDesc() {
        return this.parameterTypesDesc;
    }

    public void setParameterTypesDesc(String parameterTypesDesc) {
        this.parameterTypesDesc = parameterTypesDesc;
    }

    @Override
    public String[] getCompatibleParamSignatures() {
        return this.compatibleParamSignatures;
    }

    public void setCompatibleParamSignatures(String[] compatibleParamSignatures) {
        this.compatibleParamSignatures = compatibleParamSignatures;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments == null ? new Object[]{} : arguments;
    }

    @Override
    public Map<String, Object> getObjectAttachments() {
        return this.attachments;
    }

    public void setObjectAttachments(Map<String, Object> attachments) {
        this.attachments = attachments == null ? new LinkedHashMap() : attachments;
    }

    @Override
    public void setAttachment(String key, String value) {
        this.setObjectAttachment(key, value);
    }

    @Override
    @Deprecated
    public Map<String, String> getAttachments() {
        return new AttachmentsAdapter.ObjectToStringMap(this.attachments);
    }

    @Deprecated
    public void setAttachments(Map<String, String> attachments) {
        this.attachments = attachments == null ? new LinkedHashMap<String, Object>() : new LinkedHashMap<String, String>(attachments);
    }

    @Override
    public void setAttachment(String key, Object value) {
        this.setObjectAttachment(key, value);
    }

    @Override
    public void setObjectAttachment(String key, Object value) {
        if (this.attachments == null) {
            this.attachments = new LinkedHashMap<String, Object>();
        }
        this.attachments.put(key, value);
    }

    @Override
    public void setAttachmentIfAbsent(String key, String value) {
        this.setObjectAttachmentIfAbsent(key, value);
    }

    @Override
    public void setAttachmentIfAbsent(String key, Object value) {
        this.setObjectAttachmentIfAbsent(key, value);
    }

    @Override
    public void setObjectAttachmentIfAbsent(String key, Object value) {
        if (this.attachments == null) {
            this.attachments = new LinkedHashMap<String, Object>();
        }
        if (!this.attachments.containsKey(key)) {
            this.attachments.put(key, value);
        }
    }

    @Deprecated
    public void addAttachments(Map<String, String> attachments) {
        if (attachments == null) {
            return;
        }
        if (this.attachments == null) {
            this.attachments = new LinkedHashMap<String, Object>();
        }
        this.attachments.putAll(attachments);
    }

    public void addObjectAttachments(Map<String, Object> attachments) {
        if (attachments == null) {
            return;
        }
        if (this.attachments == null) {
            this.attachments = new LinkedHashMap<String, Object>();
        }
        this.attachments.putAll(attachments);
    }

    @Deprecated
    public void addAttachmentsIfAbsent(Map<String, String> attachments) {
        if (attachments == null) {
            return;
        }
        for (Map.Entry<String, String> entry : attachments.entrySet()) {
            this.setAttachmentIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    public void addObjectAttachmentsIfAbsent(Map<String, Object> attachments) {
        if (attachments == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : attachments.entrySet()) {
            this.setAttachmentIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Deprecated
    public String getAttachment(String key) {
        if (this.attachments == null) {
            return null;
        }
        Object value = this.attachments.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    public Object getObjectAttachment(String key) {
        if (this.attachments == null) {
            return null;
        }
        Object val = this.attachments.get(key);
        if (val != null) {
            return val;
        }
        return this.attachments.get(key.toLowerCase(Locale.ROOT));
    }

    @Override
    @Deprecated
    public String getAttachment(String key, String defaultValue) {
        if (this.attachments == null) {
            return defaultValue;
        }
        Object value = this.attachments.get(key);
        if (value instanceof String) {
            String strValue = (String)value;
            if (StringUtils.isEmpty((String)strValue)) {
                return defaultValue;
            }
            return strValue;
        }
        return null;
    }

    @Override
    @Deprecated
    public Object getObjectAttachment(String key, Object defaultValue) {
        if (this.attachments == null) {
            return defaultValue;
        }
        Object value = this.attachments.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public Object getObjectAttachmentWithoutConvert(String key) {
        if (this.attachments == null) {
            return null;
        }
        return this.attachments.get(key);
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public Type[] getReturnTypes() {
        return this.returnTypes;
    }

    public void setReturnTypes(Type[] returnTypes) {
        this.returnTypes = returnTypes;
    }

    public InvokeMode getInvokeMode() {
        return this.invokeMode;
    }

    public void setInvokeMode(InvokeMode invokeMode) {
        this.invokeMode = invokeMode;
    }

    public String toString() {
        return "RpcInvocation [methodName=" + this.methodName + ", parameterTypes=" + Arrays.toString(this.parameterTypes) + ", arguments=" + Arrays.toString(this.arguments) + ", attachments=" + this.attachments + "]";
    }
}

