/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.spring;

import java.lang.annotation.Annotation;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.rest.ParamType;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.AbstractSpringArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.support.spring.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

@Activate(onClass={"org.springframework.web.bind.annotation.ModelAttribute"})
public final class ModelAttributeArgumentResolver
extends AbstractSpringArgumentResolver {
    public Class<Annotation> accept() {
        return Annotations.ModelAttribute.type();
    }

    protected ParamType getParamType(NamedValueMeta meta) {
        return ParamType.Param;
    }

    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        if (meta.parameter().isSimple()) {
            return request.parameter(meta.name());
        }
        return meta.parameter().bind(request, response);
    }

    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        if (meta.parameter().isSimple()) {
            return request.parameterValues(meta.name());
        }
        return meta.parameter().bind(request, response);
    }

    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        if (TypeUtils.isSimpleProperty((Class)meta.nestedType(1))) {
            return RequestUtils.getParametersMap((HttpRequest)request);
        }
        return meta.parameter().bind(request, response);
    }
}

