/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Example;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.MediaType;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema;

public final class Parameter
extends Node<Parameter> {
    private final String name;
    private final In in;
    private String description;
    private Boolean required;
    private Boolean deprecated;
    private Boolean allowEmptyValue;
    private Style style;
    private Boolean explode;
    private Boolean allowReserved;
    private Schema schema;
    private Object example;
    private Map<String, Example> examples;
    private Map<String, MediaType> contents;
    private transient ParameterMeta meta;

    public Parameter(String name, In in) {
        this.name = Objects.requireNonNull(name);
        this.in = Objects.requireNonNull(in);
    }

    public String getName() {
        return this.name;
    }

    public In getIn() {
        return this.in;
    }

    public String getDescription() {
        return this.description;
    }

    public Parameter setDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Parameter setRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public Parameter setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public Parameter setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
        return this;
    }

    public Style getStyle() {
        return this.style;
    }

    public Parameter setStyle(Style style) {
        this.style = style;
        return this;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public Parameter setExplode(Boolean explode) {
        this.explode = explode;
        return this;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public Parameter setAllowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
        return this;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Parameter setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public Parameter setExample(Object example) {
        this.example = example;
        return this;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public Parameter setExamples(Map<String, Example> examples) {
        this.examples = examples;
        return this;
    }

    public Parameter addExample(String name, Example example) {
        if (this.examples == null) {
            this.examples = new LinkedHashMap<String, Example>();
        }
        this.examples.put(name, example);
        return this;
    }

    public Parameter removeExample(String name) {
        if (this.examples != null) {
            this.examples.remove(name);
        }
        return this;
    }

    public Map<String, MediaType> getContents() {
        return this.contents;
    }

    public Parameter setContents(Map<String, MediaType> contents) {
        this.contents = contents;
        return this;
    }

    public Parameter addContent(String name, MediaType content) {
        if (this.contents == null) {
            this.contents = new LinkedHashMap<String, MediaType>();
        }
        this.contents.put(name, content);
        return this;
    }

    public Parameter removeContent(String name) {
        if (this.contents != null) {
            this.contents.remove(name);
        }
        return this;
    }

    public ParameterMeta getMeta() {
        return this.meta;
    }

    public Parameter setMeta(ParameterMeta meta) {
        this.meta = meta;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != Parameter.class) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return this.name.equals(other.name) && this.in == other.in;
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.in.hashCode();
    }

    @Override
    public Parameter clone() {
        Parameter clone = (Parameter)super.clone();
        clone.schema = Parameter.clone(this.schema);
        clone.examples = Parameter.clone(this.examples);
        clone.contents = Parameter.clone(this.contents);
        return clone;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> node, Context context) {
        Parameter.write(node, "name", this.name);
        Parameter.write(node, "in", this.in.toString());
        Parameter.write(node, "description", this.description);
        Parameter.write(node, "required", this.required);
        Parameter.write(node, "deprecated", this.deprecated);
        Parameter.write(node, "allowEmptyValue", this.allowEmptyValue);
        Parameter.write(node, "style", (Object)this.style);
        Parameter.write(node, "explode", this.explode);
        Parameter.write(node, "allowReserved", this.allowReserved);
        Parameter.write(node, "schema", this.schema, context);
        Parameter.write(node, "example", this.example);
        Parameter.write(node, "examples", this.examples, context);
        Parameter.write(node, "content", this.contents, context);
        this.writeExtensions(node);
        return node;
    }

    public static enum In {
        PATH("path"),
        QUERY("query"),
        HEADER("header"),
        COOKIE("cookie");

        private final String value;

        private In(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Style {
        MATRIX("matrix"),
        LABEL("label"),
        FORM("form"),
        SIMPLE("simple"),
        SPACE_DELIMITED("spaceDelimited"),
        PIPE_DELIMITED("pipeDelimited"),
        DEEP_OBJECT("deepObject");

        private final String value;

        private Style(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

