/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Pair;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPIExtension;

public final class ExtensionFactory {
    private final ExtensionLoader<OpenAPIExtension> extensionLoader;
    private final List<OpenAPIExtension> extensions;
    private final Map<Object, Object> cache;

    public ExtensionFactory(FrameworkModel frameworkModel) {
        this.extensionLoader = frameworkModel.getExtensionLoader(OpenAPIExtension.class);
        this.extensions = this.extensionLoader.getActivateExtensions();
        this.cache = CollectionUtils.newConcurrentHashMap();
    }

    public <T extends OpenAPIExtension> boolean hasExtensions(Class<T> type) {
        return this.getExtensions(type).length > 0;
    }

    public <T extends OpenAPIExtension> T[] getExtensions(Class<T> type) {
        return (OpenAPIExtension[])this.cache.computeIfAbsent(type, k -> {
            ArrayList<OpenAPIExtension> list = new ArrayList<OpenAPIExtension>();
            for (OpenAPIExtension extension : this.extensions) {
                if (extension instanceof Supplier) {
                    extension = (OpenAPIExtension)((Supplier)((Object)extension)).get();
                }
                if (!type.isInstance(extension)) continue;
                list.add(extension);
            }
            return list.toArray((OpenAPIExtension[])Array.newInstance(type, list.size()));
        });
    }

    public <T extends OpenAPIExtension> T[] getExtensions(Class<T> type, String group) {
        if (group == null) {
            return this.getExtensions(type);
        }
        return (OpenAPIExtension[])this.cache.computeIfAbsent(Pair.of(type, (Object)group), k -> {
            ArrayList<OpenAPIExtension> list = new ArrayList<OpenAPIExtension>();
            for (OpenAPIExtension extension : this.extensions) {
                if (extension instanceof Supplier) {
                    extension = (OpenAPIExtension)((Supplier)((Object)extension)).get();
                }
                if (!type.isInstance(extension) || !ExtensionFactory.accept(extension, group)) continue;
                list.add(extension);
            }
            return list.toArray((OpenAPIExtension[])Array.newInstance(type, list.size()));
        });
    }

    public <T extends OpenAPIExtension> T getExtension(Class<T> type, String name) {
        OpenAPIExtension extension = (OpenAPIExtension)this.extensionLoader.getExtension(name, true);
        if (extension instanceof Supplier) {
            extension = (OpenAPIExtension)((Supplier)((Object)extension)).get();
        }
        return (T)(type.isInstance(extension) ? extension : null);
    }

    private static boolean accept(OpenAPIExtension extension, String group) {
        String[] groups = extension.getGroups();
        return groups == null || groups.length == 0 || Arrays.asList(groups).contains(group);
    }
}

