/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.FluentLogger;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.config.nested.OpenAPIConfig;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.rest.OpenAPIRequest;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ConfigFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ExtensionFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPINamingStrategy;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.ApiResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Components;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Contact;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.ExternalDocs;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Header;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Info;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.License;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.MediaType;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.OpenAPI;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Operation;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Parameter;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.PathItem;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.RequestBody;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.SecurityRequirement;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.SecurityScheme;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Server;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Tag;

final class DefinitionMerger {
    private static final FluentLogger LOG = FluentLogger.of(DefinitionMerger.class);
    private static final String NAMING_STRATEGY_PREFIX = "naming-strategy-";
    private static final String NAMING_STRATEGY_DEFAULT = "default";
    private static Type SECURITY_SCHEMES_TYPE;
    private static Type SECURITY_TYPE;
    private final ExtensionFactory extensionFactory;
    private final ConfigFactory configFactory;
    private OpenAPINamingStrategy openAPINamingStrategy;

    DefinitionMerger(FrameworkModel frameworkModel) {
        this.extensionFactory = (ExtensionFactory)frameworkModel.getOrRegisterBean(ExtensionFactory.class);
        this.configFactory = (ConfigFactory)frameworkModel.getOrRegisterBean(ConfigFactory.class);
    }

    private OpenAPINamingStrategy getNamingStrategy() {
        if (this.openAPINamingStrategy == null) {
            String strategy = this.configFactory.getGlobalConfig().getNameStrategy();
            String name = NAMING_STRATEGY_PREFIX + (strategy == null ? NAMING_STRATEGY_DEFAULT : strategy);
            this.openAPINamingStrategy = this.extensionFactory.getExtension(OpenAPINamingStrategy.class, name);
            Objects.requireNonNull(this.openAPINamingStrategy, "Can't find OpenAPINamingStrategy with name: " + name);
        }
        return this.openAPINamingStrategy;
    }

    public OpenAPI merge(List<OpenAPI> openAPIs, OpenAPIRequest request) {
        Info info = new Info();
        OpenAPI target = new OpenAPI().setInfo(info);
        OpenAPIConfig globalConfig = this.configFactory.getGlobalConfig();
        target.setGlobalConfig(globalConfig);
        this.applyConfig(target, globalConfig);
        if (openAPIs.isEmpty()) {
            return target;
        }
        String group = request.getGroup();
        if (group == null) {
            group = NAMING_STRATEGY_DEFAULT;
        }
        target.setGroup(group);
        String version = request.getVersion();
        if (version != null) {
            info.setVersion(version);
        }
        target.setOpenapi(Helper.formatSpecVersion(request.getOpenapi()));
        OpenAPIConfig config = this.configFactory.getConfig(group);
        target.setConfig(config);
        String[] tags = request.getTag();
        String[] services = request.getService();
        for (int i = openAPIs.size() - 1; i >= 0; --i) {
            OpenAPI source = openAPIs.get(i);
            if (DefinitionMerger.isServiceNotMatch(source.getMeta().getServiceInterface(), services)) continue;
            if (group.equals(source.getGroup())) {
                this.mergeBasic(target, source);
            }
            this.mergePaths(target, source, group, version, tags);
            this.mergeSecuritySchemes(target, source);
            this.mergeTags(target, source);
        }
        this.applyConfig(target, config);
        this.addSchemas(target, version, group);
        this.completeOperations(target);
        this.completeModel(target);
        return target;
    }

    private void applyConfig(OpenAPI target, OpenAPIConfig config) {
        String security;
        String securityScheme;
        if (config == null) {
            return;
        }
        Info info = target.getInfo();
        Helper.setValue(() -> ((OpenAPIConfig)config).getInfoTitle(), info::setTitle);
        Helper.setValue(() -> ((OpenAPIConfig)config).getInfoDescription(), info::setDescription);
        Helper.setValue(() -> ((OpenAPIConfig)config).getInfoVersion(), info::setVersion);
        Contact contact = info.getContact();
        if (contact == null) {
            contact = new Contact();
            info.setContact(contact);
        }
        Helper.setValue(() -> ((OpenAPIConfig)config).getInfoContactName(), contact::setName);
        Helper.setValue(() -> ((OpenAPIConfig)config).getInfoContactUrl(), contact::setUrl);
        Helper.setValue(() -> ((OpenAPIConfig)config).getInfoContactEmail(), contact::setEmail);
        ExternalDocs externalDocs = target.getExternalDocs();
        if (externalDocs == null) {
            externalDocs = new ExternalDocs();
            target.setExternalDocs(externalDocs);
        }
        Helper.setValue(() -> ((OpenAPIConfig)config).getExternalDocsDescription(), externalDocs::setDescription);
        Helper.setValue(() -> ((OpenAPIConfig)config).getExternalDocsUrl(), externalDocs::setUrl);
        String[] servers = config.getServers();
        if (servers != null) {
            target.setServers(Arrays.stream(servers).map(Helper::parseServer).collect(Collectors.toList()));
        }
        Components components = target.getComponents();
        if (target.getComponents() == null) {
            components = new Components();
            target.setComponents(components);
        }
        if ((securityScheme = config.getSecurityScheme()) != null) {
            try {
                if (SECURITY_SCHEMES_TYPE == null) {
                    SECURITY_SCHEMES_TYPE = Components.class.getDeclaredField("securitySchemes").getGenericType();
                }
                components.setSecuritySchemes((Map)JsonUtils.toJavaObject((String)securityScheme, (Type)SECURITY_SCHEMES_TYPE));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if ((security = config.getSecurity()) != null) {
            try {
                if (SECURITY_TYPE == null) {
                    SECURITY_TYPE = OpenAPI.class.getDeclaredField("security").getGenericType();
                }
                target.setSecurity((List)JsonUtils.toJavaObject((String)securityScheme, (Type)SECURITY_TYPE));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    private void mergeBasic(OpenAPI target, OpenAPI source) {
        ExternalDocs sourceExternalDocs;
        this.mergeInfo(target, source);
        if (target.getServers() == null) {
            target.setServers(Node.clone(source.getServers()));
        }
        List<SecurityRequirement> sourceSecurity = source.getSecurity();
        if (target.getSecurity() == null) {
            target.setSecurity(Node.clone(sourceSecurity));
        }
        if ((sourceExternalDocs = source.getExternalDocs()) != null) {
            ExternalDocs targetExternalDocs = target.getExternalDocs();
            Helper.setValue(sourceExternalDocs::getDescription, targetExternalDocs::setDescription);
            Helper.setValue(sourceExternalDocs::getUrl, targetExternalDocs::setUrl);
            targetExternalDocs.addExtensions(sourceExternalDocs.getExtensions());
        }
        target.addExtensions(source.getExtensions());
    }

    private void mergeInfo(OpenAPI target, OpenAPI source) {
        License sourceLicense;
        Info sourceInfo = source.getInfo();
        if (sourceInfo == null) {
            return;
        }
        Info info = target.getInfo();
        Helper.setValue(sourceInfo::getTitle, info::setTitle);
        Helper.setValue(sourceInfo::getSummary, info::setSummary);
        Helper.setValue(sourceInfo::getDescription, info::setDescription);
        Helper.setValue(sourceInfo::getTermsOfService, info::setTermsOfService);
        Helper.setValue(sourceInfo::getVersion, info::setVersion);
        Contact sourceContact = sourceInfo.getContact();
        if (sourceContact != null) {
            Contact contact = info.getContact();
            Helper.setValue(sourceContact::getName, contact::setName);
            Helper.setValue(sourceContact::getUrl, contact::setUrl);
            Helper.setValue(sourceContact::getEmail, contact::setEmail);
            contact.addExtensions(sourceContact.getExtensions());
        }
        if ((sourceLicense = sourceInfo.getLicense()) != null) {
            License license = info.getLicense();
            if (license == null) {
                license = new License();
                info.setLicense(license);
            }
            Helper.setValue(sourceLicense::getName, license::setName);
            Helper.setValue(sourceLicense::getUrl, license::setUrl);
            license.addExtensions(sourceLicense.getExtensions());
        }
        info.addExtensions(sourceInfo.getExtensions());
    }

    private void mergePaths(OpenAPI target, OpenAPI source, String group, String version, String[] tags) {
        Map<String, PathItem> sourcePaths = source.getPaths();
        if (sourcePaths == null) {
            return;
        }
        Map<String, PathItem> paths = target.getPaths();
        if (paths == null) {
            paths = new TreeMap<String, PathItem>();
            target.setPaths(paths);
        }
        for (Map.Entry<String, PathItem> entry : sourcePaths.entrySet()) {
            String ref;
            String path = entry.getKey();
            PathItem sourcePathItem = entry.getValue();
            PathItem pathItem = paths.get(path);
            if (pathItem != null && (ref = sourcePathItem.getRef()) != null) {
                pathItem = paths.get(ref);
            }
            if (pathItem == null) {
                pathItem = new PathItem();
                paths.put(path, pathItem);
            }
            this.mergePath(path, pathItem, sourcePathItem, group, version, tags);
        }
    }

    private void mergePath(String path, PathItem target, PathItem source, String group, String version, String[] tags) {
        List<Parameter> sourceParameters;
        List<Server> sourceServers;
        Map<HttpMethods, Operation> sourceOperations;
        if (target.getRef() == null) {
            target.setRef(source.getRef());
        }
        if (target.getSummary() == null) {
            target.setSummary(source.getSummary());
        }
        if (target.getDescription() == null) {
            target.setDescription(source.getDescription());
        }
        if ((sourceOperations = source.getOperations()) != null) {
            for (Map.Entry<HttpMethods, Operation> entry : sourceOperations.entrySet()) {
                HttpMethods httpMethod = entry.getKey();
                Operation sourceOperation = entry.getValue();
                if (DefinitionMerger.isGroupNotMatch(group, sourceOperation.getGroup()) || DefinitionMerger.isVersionNotMatch(version, sourceOperation.getVersion()) || DefinitionMerger.isTagNotMatch(tags, sourceOperation.getTags())) continue;
                Operation operation = target.getOperation(httpMethod);
                if (operation == null) {
                    target.addOperation(httpMethod, sourceOperation.clone());
                    continue;
                }
                if (operation.getMeta() == null) continue;
                LOG.internalWarn("Operation already exists, path='{}', httpMethod='{}', method={}", new Object[]{path, httpMethod, sourceOperation.getMeta()});
            }
        }
        if (target.getServers() == null && (sourceServers = source.getServers()) != null) {
            target.setServers(Node.clone(sourceServers));
        }
        if ((sourceParameters = source.getParameters()) != null) {
            if (target.getParameters() == null) {
                target.setParameters(Node.clone(sourceParameters));
            } else {
                for (Parameter parameter : sourceParameters) {
                    target.addParameter(parameter.clone());
                }
            }
        }
        target.addExtensions(source.getExtensions());
    }

    private static boolean isServiceNotMatch(String apiService, String[] services) {
        if (apiService == null || services == null) {
            return false;
        }
        for (String service : services) {
            if (!apiService.regionMatches(true, 0, service, 0, service.length())) continue;
            return false;
        }
        return true;
    }

    private static boolean isGroupNotMatch(String group, String sourceGroup) {
        return (sourceGroup != null || !NAMING_STRATEGY_DEFAULT.equals(group)) && !"all".equals(group) && !group.equals(sourceGroup);
    }

    private static boolean isVersionNotMatch(String version, String sourceVersion) {
        return version != null && sourceVersion != null && !Helper.isVersionGreaterOrEqual(sourceVersion, version);
    }

    private static boolean isTagNotMatch(String[] tags, Set<String> operationTags) {
        if (tags == null || operationTags == null) {
            return false;
        }
        for (String tag : tags) {
            if (!operationTags.contains(tag)) continue;
            return false;
        }
        return true;
    }

    private void mergeSecuritySchemes(OpenAPI target, OpenAPI source) {
        Components sourceComponents = source.getComponents();
        if (sourceComponents == null) {
            return;
        }
        Map<String, SecurityScheme> sourceSecuritySchemes = sourceComponents.getSecuritySchemes();
        if (sourceSecuritySchemes == null) {
            return;
        }
        Components components = target.getComponents();
        Map<String, SecurityScheme> securitySchemes = components.getSecuritySchemes();
        if (securitySchemes == null) {
            components.setSecuritySchemes(Node.clone(sourceSecuritySchemes));
        } else {
            for (Map.Entry<String, SecurityScheme> entry : sourceSecuritySchemes.entrySet()) {
                securitySchemes.computeIfAbsent(entry.getKey(), k -> ((SecurityScheme)entry.getValue()).clone());
            }
        }
    }

    private void mergeTags(OpenAPI target, OpenAPI source) {
        List<Tag> sourceTags = source.getTags();
        if (sourceTags == null) {
            return;
        }
        if (target.getTags() == null) {
            target.setTags(Node.clone(sourceTags));
        } else {
            for (Tag tag : sourceTags) {
                target.addTag(tag.clone());
            }
        }
    }

    private void addSchemas(OpenAPI target, String version, String group) {
        Map<String, PathItem> paths = target.getPaths();
        if (paths == null) {
            return;
        }
        IdentityHashMap<Schema, Schema> schemas = new IdentityHashMap<Schema, Schema>();
        for (PathItem pathItem : paths.values()) {
            Map<HttpMethods, Operation> operations = pathItem.getOperations();
            if (operations == null) continue;
            for (Operation operation : operations.values()) {
                Map<String, ApiResponse> responses;
                RequestBody requestBody;
                List<Parameter> parameters = operation.getParameters();
                if (parameters != null) {
                    for (Parameter parameter : parameters) {
                        this.addSchema(parameter.getSchema(), schemas, group, version);
                        Map<String, MediaType> contents = parameter.getContents();
                        if (contents == null) continue;
                        for (MediaType content : contents.values()) {
                            this.addSchema(content.getSchema(), schemas, group, version);
                        }
                    }
                }
                if ((requestBody = operation.getRequestBody()) != null) {
                    Map<String, MediaType> contents = requestBody.getContents();
                    if (contents == null) continue;
                    for (MediaType content : contents.values()) {
                        this.addSchema(content.getSchema(), schemas, group, version);
                    }
                }
                if ((responses = operation.getResponses()) == null) continue;
                for (ApiResponse response : responses.values()) {
                    Map<String, MediaType> contents;
                    Map<String, Header> headers = response.getHeaders();
                    if (headers != null) {
                        for (Header header : headers.values()) {
                            this.addSchema(header.getSchema(), schemas, group, version);
                        }
                    }
                    if ((contents = response.getContents()) == null) continue;
                    for (MediaType content : contents.values()) {
                        this.addSchema(content.getSchema(), schemas, group, version);
                    }
                }
            }
        }
        Components components = target.getComponents();
        if (components == null) {
            components = new Components();
            target.setComponents(components);
        }
        Set names = CollectionUtils.newHashSet((int)schemas.size());
        for (Schema schema : schemas.keySet()) {
            String name = schema.getName();
            if (name == null) continue;
            names.add(name);
        }
        OpenAPINamingStrategy strategy = this.getNamingStrategy();
        for (Schema schema : schemas.values()) {
            String name = schema.getName();
            if (name == null) {
                Class<?> clazz = schema.getJavaType();
                name = strategy.generateSchemaName(clazz, target);
                for (int i = 1; i < 100; ++i) {
                    if (!names.contains(name)) {
                        names.add(name);
                        break;
                    }
                    name = strategy.resolveSchemaNameConflict(i, name, clazz, target);
                }
                schema.setName(name);
            }
            for (Schema sourceSchema : schema.getSourceSchemas()) {
                sourceSchema.setTargetSchema(schema);
                sourceSchema.setRef("#/components/schemas/" + name);
            }
            schema.setSourceSchemas(null);
            components.addSchema(name, schema);
        }
    }

    private void addSchema(Schema schema, Map<Schema, Schema> schemas, String group, String version) {
        List<Schema> list;
        List<Schema> oneOf;
        if (schema == null) {
            return;
        }
        this.addSchema(schema.getItems(), schemas, group, version);
        Map<String, Schema> properties = schema.getProperties();
        if (properties != null) {
            Iterator<Map.Entry<String, Schema>> it = properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Schema> entry = it.next();
                Schema schema2 = entry.getValue();
                if (DefinitionMerger.isGroupNotMatch(group, schema2.getGroup()) || DefinitionMerger.isVersionNotMatch(version, schema2.getVersion())) {
                    it.remove();
                    continue;
                }
                this.addSchema(schema2, schemas, group, version);
            }
        }
        this.addSchema(schema.getAdditionalPropertiesSchema(), schemas, group, version);
        List<Schema> allOf = schema.getAllOf();
        if (allOf != null) {
            for (Schema schema3 : allOf) {
                this.addSchema(schema3, schemas, group, version);
            }
        }
        if ((oneOf = schema.getOneOf()) != null) {
            for (Schema schema4 : oneOf) {
                this.addSchema(schema4, schemas, group, version);
            }
        }
        if ((list = schema.getAnyOf()) != null) {
            for (Schema item : list) {
                this.addSchema(item, schemas, group, version);
            }
        }
        this.addSchema(schema.getNot(), schemas, group, version);
        Schema schema5 = schema.getTargetSchema();
        if (schema5 == null) {
            return;
        }
        schema5.addSourceSchema(schema);
        Schema newSchema = schemas.get(schema5);
        if (newSchema == null) {
            newSchema = schema5.clone();
            schemas.put(schema5, newSchema);
            this.addSchema(newSchema, schemas, group, version);
        }
    }

    private void completeOperations(OpenAPI target) {
        Map<String, PathItem> paths = target.getPaths();
        if (paths == null) {
            return;
        }
        HashSet allOperationIds = new HashSet(32);
        HashSet allTags = new HashSet(32);
        target.walkOperations(operation -> {
            Set<String> tags;
            String operationId = operation.getOperationId();
            if (operationId != null) {
                allOperationIds.add(operationId);
            }
            if ((tags = operation.getTags()) != null) {
                allTags.addAll(tags);
            }
        });
        OpenAPINamingStrategy strategy = this.getNamingStrategy();
        target.walkOperations(operation -> {
            String id = operation.getOperationId();
            if (id != null) {
                return;
            }
            id = strategy.generateOperationId(operation.getMeta(), target);
            for (int i = 1; i < 100; ++i) {
                if (!allOperationIds.contains(id)) {
                    allOperationIds.add(id);
                    break;
                }
                id = strategy.resolveOperationIdConflict(i, id, operation.getMeta(), target);
            }
            operation.setOperationId(id);
        });
        List<Tag> tags = target.getTags();
        if (tags != null) {
            ListIterator<Tag> it = tags.listIterator();
            while (it.hasNext()) {
                if (allTags.contains(it.next().getName())) continue;
                it.remove();
            }
        }
    }

    private void completeModel(OpenAPI target) {
        Info info = target.getInfo();
        if (info.getTitle() == null) {
            info.setTitle("Dubbo OpenAPI");
        }
        if (info.getVersion() == null) {
            info.setVersion("v1");
        }
        if (CollectionUtils.isEmptyMap(target.getPaths())) {
            return;
        }
        ExternalDocs docs = target.getExternalDocs();
        if (docs.getUrl() == null && docs.getDescription() == null) {
            docs.setUrl("../redoc/index.html?group=" + target.getGroup()).setDescription("ReDoc");
        }
    }
}

