/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ExtensionFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.SchemaResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.OpenAPI;

public abstract class AbstractContext {
    private final OpenAPI openAPI;
    private final SchemaResolver schemaResolver;
    private final ExtensionFactory extensionFactory;
    private Map<String, Object> attributes;

    AbstractContext(OpenAPI openAPI, SchemaResolver schemaResolver, ExtensionFactory extensionFactory) {
        this.openAPI = openAPI;
        this.schemaResolver = schemaResolver;
        this.extensionFactory = extensionFactory;
    }

    public final String getGroup() {
        return this.openAPI.getGroup();
    }

    public final OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    public final SchemaResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public final ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    public final <T> T getAttribute(String name) {
        return (T)(this.attributes == null ? null : this.attributes.get(name));
    }

    public final <T> T removeAttribute(String name) {
        return (T)(this.attributes == null ? null : this.attributes.remove(name));
    }

    public final void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }
}

