/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.swagger;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.nested.OpenAPIConfig;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.rest.OpenAPIService;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ConfigFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPIRequestHandler;
import org.apache.dubbo.rpc.protocol.tri.rest.support.swagger.WebjarHelper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.PathUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;

@Activate
public class SwaggerUIRequestHandler
implements OpenAPIRequestHandler {
    private static final String DEFAULT_CDN = "https://unpkg.com/swagger-ui-dist@5.18.2";
    private static final String INDEX_PATH = "/META-INF/resources/swagger-ui/index.html";
    private final FrameworkModel frameworkModel;
    private final ConfigFactory configFactory;
    private OpenAPIConfig config;

    public SwaggerUIRequestHandler(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.configFactory = (ConfigFactory)frameworkModel.getOrRegisterBean(ConfigFactory.class);
    }

    private OpenAPIConfig getConfig() {
        if (this.config == null) {
            this.config = this.configFactory.getGlobalConfig();
        }
        return this.config;
    }

    @Override
    public String[] getPaths() {
        return new String[]{"/swagger-ui/{*path}"};
    }

    @Override
    public HttpResult<?> handle(String path, HttpRequest request, HttpResponse response) {
        String requestPath;
        String resPath = RequestUtils.getPathVariable((HttpRequest)request, (String)"path");
        if (StringUtils.isEmpty((String)resPath)) {
            throw HttpResult.found((String)PathUtils.join((String)request.uri(), (String)"index.html")).toPayload();
        }
        switch (requestPath = StringUtils.substringBeforeLast((String)resPath, (int)46)) {
            case "index": {
                return this.handleIndex();
            }
            case "swagger-config": {
                return this.handleSwaggerConfig();
            }
        }
        if (WebjarHelper.ENABLED && requestPath.startsWith("assets/")) {
            return WebjarHelper.getInstance().handleAssets("swagger-ui", resPath.substring(7));
        }
        throw new HttpStatusException(HttpStatus.NOT_FOUND.getCode());
    }

    private HttpResult<?> handleIndex() {
        HashMap<String, String> variables = new HashMap<String, String>(4);
        OpenAPIConfig config = this.getConfig();
        String cdn = config.getSetting("swagger-ui.cdn");
        if (cdn == null) {
            cdn = WebjarHelper.ENABLED && WebjarHelper.getInstance().hasWebjar("swagger-ui") ? "./assets" : DEFAULT_CDN;
        }
        variables.put("swagger-ui.cdn", cdn);
        Map settings = config.getSettings();
        if (settings != null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : settings.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("swagger-ui.settings.")) continue;
                sb.append(",\n            \"").append(key.substring(20)).append("\": ").append((String)entry.getValue());
            }
            if (sb.length() > 0) {
                variables.put("swagger-ui.settings", sb.toString());
            }
        }
        try {
            String content = StreamUtils.toString((InputStream)this.getClass().getResourceAsStream(INDEX_PATH));
            return HttpResult.of((Object)Helper.render(content, variables::get).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR.getCode(), (Throwable)e);
        }
    }

    private HttpResult<?> handleSwaggerConfig() {
        OpenAPIService openAPIService = (OpenAPIService)this.frameworkModel.getBean(OpenAPIService.class);
        if (openAPIService == null) {
            return HttpResult.notFound();
        }
        Collection groups = openAPIService.getOpenAPIGroups();
        ArrayList urls = new ArrayList();
        for (String group : groups) {
            LinkedHashMap<String, String> url = new LinkedHashMap<String, String>(4);
            url.put("name", group);
            url.put("url", "../api-docs/" + group);
            urls.add(url);
        }
        LinkedHashMap configMap = new LinkedHashMap();
        configMap.put("urls", urls);
        return HttpResult.of((Object)JsonUtils.toJson(configMap).getBytes(StandardCharsets.UTF_8));
    }
}

