/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Parameter;

public final class Encoding
extends Node<Encoding> {
    private String contentType;
    private Map<String, Parameter> headers;
    private Style style;
    private Boolean explode;
    private Boolean allowReserved;

    public String getContentType() {
        return this.contentType;
    }

    public Encoding setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Map<String, Parameter> getHeaders() {
        return this.headers;
    }

    public Parameter getHeader(String name) {
        return this.headers == null ? null : this.headers.get(name);
    }

    public Encoding setHeaders(Map<String, Parameter> headers) {
        this.headers = headers;
        return this;
    }

    public Encoding addHeader(String name, Parameter header) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, Parameter>();
        }
        this.headers.put(name, header);
        return this;
    }

    public Encoding removeHeader(String name) {
        if (this.headers != null) {
            this.headers.remove(name);
        }
        return this;
    }

    public Style getStyle() {
        return this.style;
    }

    public Encoding setStyle(Style style) {
        this.style = style;
        return this;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public Encoding setExplode(Boolean explode) {
        this.explode = explode;
        return this;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public Encoding setAllowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
        return this;
    }

    @Override
    public Encoding clone() {
        Encoding clone = (Encoding)super.clone();
        clone.headers = Encoding.clone(this.headers);
        return clone;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> encoding, Context context) {
        Encoding.write(encoding, "contentType", this.contentType);
        Encoding.write(encoding, "headers", this.headers, context);
        Encoding.write(encoding, "style", (Object)this.style);
        Encoding.write(encoding, "explode", this.explode);
        Encoding.write(encoding, "allowReserved", this.allowReserved);
        this.writeExtensions(encoding);
        return encoding;
    }

    public static enum Style {
        FORM("form"),
        SPACE_DELIMITED("spaceDelimited"),
        PIPE_DELIMITED("pipeDelimited"),
        DEEP_OBJECT("deepObject");

        private final String value;

        private Style(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

