/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.FluentLogger;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.nested.OpenAPIConfig;
import org.apache.dubbo.remoting.http12.ErrorResponse;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpUtils;
import org.apache.dubbo.remoting.http12.rest.ParamType;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.Registration;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.RequestMapping;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.MethodsCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathCondition;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathExpression;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.BeanMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.AbstractContext;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ConfigFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ExtensionFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPIDefinitionResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.PrimitiveSchema;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.SchemaResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.ApiResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.MediaType;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.OpenAPI;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Operation;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Parameter;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.PathItem;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.RequestBody;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Server;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Tag;

final class DefinitionResolver {
    private static final FluentLogger LOG = FluentLogger.of(DefinitionResolver.class);
    private final ExtensionFactory extensionFactory;
    private final ConfigFactory configFactory;
    private final SchemaResolver schemaResolver;
    private final OpenAPIDefinitionResolver[] resolvers;

    DefinitionResolver(FrameworkModel frameworkModel) {
        this.extensionFactory = (ExtensionFactory)frameworkModel.getOrRegisterBean(ExtensionFactory.class);
        this.configFactory = (ConfigFactory)frameworkModel.getOrRegisterBean(ConfigFactory.class);
        this.schemaResolver = (SchemaResolver)frameworkModel.getOrRegisterBean(SchemaResolver.class);
        this.resolvers = (OpenAPIDefinitionResolver[])this.extensionFactory.getExtensions(OpenAPIDefinitionResolver.class);
    }

    public OpenAPI resolve(ServiceMeta serviceMeta, Collection<List<Registration>> registrationsByMethod) {
        OpenAPI definition = new OpenAPIChainImpl(this.resolvers, openAPI -> {
            if (StringUtils.isEmpty((String)openAPI.getGroup())) {
                openAPI.setGroup("default");
            }
            openAPI.setConfig(this.configFactory.getConfig(openAPI.getGroup()));
            String service = serviceMeta.getServiceInterface();
            int index = service.lastIndexOf(46);
            String tagName = index == -1 ? service : service.substring(index + 1);
            openAPI.addTag(new Tag().setName(tagName).setDescription(service));
            return openAPI;
        }).resolve(new OpenAPI().setMeta(serviceMeta).setGlobalConfig(this.configFactory.getGlobalConfig()), serviceMeta);
        if (definition == null) {
            return null;
        }
        if (definition.getConfig() == null) {
            definition.setConfig(this.configFactory.getConfig(definition.getGroup()));
        }
        if (CollectionUtils.isEmpty(definition.getServers())) {
            URL url = serviceMeta.getUrl();
            definition.addServer(new Server().setUrl("http://" + url.getHost() + ':' + url.getPort()).setDescription("Dubbo Default Server"));
        }
        OperationContextImpl context = new OperationContextImpl(definition, this.schemaResolver, this.extensionFactory);
        for (List<Registration> registrations : registrationsByMethod) {
            String mainPath = null;
            for (Registration registration : registrations) {
                RequestMapping mapping = registration.getMapping();
                PathCondition pathCondition = mapping.getPathCondition();
                if (pathCondition == null) continue;
                for (PathExpression expression : pathCondition.getExpressions()) {
                    String path = expression.toString();
                    PathItem pathItem = definition.getOrAddPath(path);
                    String ref = pathItem.getRef();
                    if (ref != null) {
                        path = ref;
                        pathItem = definition.getOrAddPath(path);
                    }
                    if (mainPath != null && expression.isDirect()) {
                        pathItem.setRef(mainPath);
                        continue;
                    }
                    MethodMeta methodMeta = registration.getMeta().getMethod();
                    if (!this.resolvePath(path, pathItem, definition, methodMeta, mapping, context)) continue;
                    mainPath = path;
                }
            }
        }
        return definition;
    }

    /*
     * WARNING - void declaration
     */
    private boolean resolvePath(String path, PathItem pathItem, OpenAPI openAPI, MethodMeta methodMeta, RequestMapping mapping, OpenAPIDefinitionResolver.OperationContext context) {
        OpenAPIDefinitionResolver resolver;
        void var10_14;
        Collection<Object> httpMethods = null;
        OpenAPIDefinitionResolver[] openAPIDefinitionResolverArray = this.resolvers;
        int n = openAPIDefinitionResolverArray.length;
        boolean i = false;
        while (var10_14 < n && (httpMethods = (resolver = openAPIDefinitionResolverArray[var10_14]).resolve(pathItem, methodMeta, context)) == null) {
            ++var10_14;
        }
        if (httpMethods == null) {
            httpMethods = new LinkedList();
            for (String method : this.determineHttpMethods(openAPI, methodMeta, mapping)) {
                httpMethods.add(HttpMethods.of((String)method.toUpperCase()));
            }
        }
        boolean added = false;
        for (HttpMethods httpMethods2 : httpMethods) {
            Operation operation = new Operation().setMeta(methodMeta);
            Operation existingOperation = pathItem.getOperation(httpMethods2);
            if (existingOperation != null && existingOperation.getMeta() != null) {
                LOG.internalWarn("Operation already exists, path='{}', httpMethod='{}', method={}", new Object[]{path, httpMethods2, methodMeta});
                continue;
            }
            if ((operation = new OperationChainImpl(this.resolvers, op -> this.resolveOperation(path, httpMethod, (Operation)op, openAPI, methodMeta, mapping)).resolve(operation, methodMeta, context)) == null) continue;
            pathItem.addOperation(httpMethods2, operation);
            added = true;
        }
        return added;
    }

    private Collection<String> determineHttpMethods(OpenAPI openAPI, MethodMeta meta, RequestMapping mapping) {
        Collection<Object> httpMethods = null;
        MethodsCondition condition = mapping.getMethodsCondition();
        if (condition != null) {
            httpMethods = condition.getMethods();
        }
        if (httpMethods == null) {
            String[] defaultHttpMethods = openAPI.getConfigValue(OpenAPIConfig::getDefaultHttpMethods);
            httpMethods = defaultHttpMethods == null ? Helper.guessHttpMethod(meta) : Arrays.asList(defaultHttpMethods);
        }
        return httpMethods;
    }

    private Operation resolveOperation(String path, HttpMethods httpMethod, Operation operation, OpenAPI openAPI, MethodMeta meta, RequestMapping mapping) {
        List<String> variables;
        ServiceMeta serviceMeta;
        if (operation.getGroup() == null) {
            operation.setGroup(openAPI.getGroup());
        }
        for (Tag tag : openAPI.getTags()) {
            operation.addTag(tag.getName());
        }
        if (operation.getDeprecated() == null && meta.isHierarchyAnnotated(Deprecated.class)) {
            operation.setDeprecated(true);
        }
        if ((serviceMeta = meta.getServiceMeta()).getServiceVersion() != null) {
            operation.addParameter(new Parameter(TripleHeaderEnum.SERVICE_GROUP.getName(), Parameter.In.HEADER).setSchema(PrimitiveSchema.STRING.newSchema()));
        }
        if (serviceMeta.getServiceGroup() != null) {
            operation.addParameter(new Parameter(TripleHeaderEnum.SERVICE_VERSION.getName(), Parameter.In.HEADER).setSchema(PrimitiveSchema.STRING.newSchema()));
        }
        if ((variables = Helper.extractVariables(path)) != null) {
            for (String variable : variables) {
                Parameter parameter = operation.getParameter(variable, Parameter.In.PATH);
                if (parameter == null) {
                    parameter = new Parameter(variable, Parameter.In.PATH);
                    operation.addParameter(parameter);
                }
                parameter.setRequired(true);
                if (parameter.getSchema() != null) continue;
                parameter.setSchema(PrimitiveSchema.STRING.newSchema());
            }
        }
        for (ParameterMeta paramMeta : meta.getParameters()) {
            this.resolveParameter(httpMethod, operation, paramMeta, true);
        }
        if (httpMethod.supportBody()) {
            RequestBody body = operation.getRequestBody();
            if (body == null) {
                body = new RequestBody();
                operation.setRequestBody(body);
            }
            if (CollectionUtils.isEmptyMap(body.getContents())) {
                this.resolveRequestBody(body, openAPI, meta, mapping);
            }
        }
        if (CollectionUtils.isEmptyMap(operation.getResponses())) {
            String[] httpStatusCodes = openAPI.getConfigValue(OpenAPIConfig::getDefaultHttpStatusCodes);
            if (httpStatusCodes == null) {
                httpStatusCodes = new String[]{"200", "400", "500"};
            }
            for (String httpStatusCode : httpStatusCodes) {
                ApiResponse response = operation.getOrAddResponse(httpStatusCode);
                this.resolveResponse(httpStatusCode, response, openAPI, meta, mapping);
            }
        }
        return operation;
    }

    private void resolveParameter(HttpMethods httpMethod, Operation operation, ParameterMeta meta, boolean traverse) {
        Parameter.In in;
        String name = meta.getName();
        if (name == null) {
            return;
        }
        NamedValueMeta valueMeta = meta.getNamedValueMeta();
        ParamType paramType = valueMeta.paramType();
        if (paramType == null) {
            if (httpMethod.supportBody()) {
                return;
            }
            paramType = ParamType.Param;
        }
        if ((in = Helper.toIn(paramType)) == null) {
            return;
        }
        boolean simple = meta.isSimple();
        if (in != Parameter.In.QUERY && !simple) {
            return;
        }
        if (simple) {
            Schema schema;
            Parameter parameter = operation.getParameter(name, in);
            if (parameter == null) {
                parameter = new Parameter(name, in);
                operation.addParameter(parameter);
            }
            if (parameter.getRequired() == null) {
                parameter.setRequired(valueMeta.required());
            }
            if ((schema = parameter.getSchema()) == null) {
                schema = this.schemaResolver.resolve(meta);
                parameter.setSchema(schema);
            }
            if (schema.getDefaultValue() == null) {
                schema.setDefaultValue(valueMeta.defaultValue());
            }
            parameter.setMeta(meta);
            return;
        }
        if (!traverse) {
            return;
        }
        BeanMeta beanMeta = meta.getBeanMeta();
        try {
            for (BeanMeta.ConstructorParameterMeta ctorParam : beanMeta.getConstructor().getParameters()) {
                this.resolveParameter(httpMethod, operation, (ParameterMeta)ctorParam, false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (BeanMeta.PropertyMeta property : beanMeta.getProperties()) {
            if ((property.getVisibility() & 1) == 0) continue;
            this.resolveParameter(httpMethod, operation, (ParameterMeta)property, false);
        }
    }

    private void resolveRequestBody(RequestBody body, OpenAPI openAPI, MethodMeta meta, RequestMapping mapping) {
        Collection<Object> mediaTypes = null;
        if (mapping.getConsumesCondition() != null) {
            mediaTypes = mapping.getConsumesCondition().getMediaTypes();
        }
        if (mediaTypes == null) {
            String[] defaultMediaTypes = openAPI.getConfigValue(OpenAPIConfig::getDefaultConsumesMediaTypes);
            mediaTypes = defaultMediaTypes == null ? Collections.singletonList(org.apache.dubbo.remoting.http12.message.MediaType.APPLICATION_JSON) : (Collection)Arrays.stream(defaultMediaTypes).map(org.apache.dubbo.remoting.http12.message.MediaType::of).collect(Collectors.toList());
        }
        block0: for (org.apache.dubbo.remoting.http12.message.MediaType mediaType : mediaTypes) {
            MediaType content = body.getOrAddContent(mediaType.getName());
            if (content.getSchema() != null) continue;
            for (ParameterMeta paramMeta : meta.getParameters()) {
                ParamType paramType = paramMeta.getNamedValueMeta().paramType();
                if (paramType != ParamType.Body) continue;
                content.setSchema(this.schemaResolver.resolve(paramMeta));
                continue block0;
            }
            ArrayList<ParameterMeta> paramMetas = new ArrayList<ParameterMeta>();
            for (ParameterMeta paramMeta : meta.getParameters()) {
                if (paramMeta.getNamedValueMeta().paramType() != null) continue;
                paramMetas.add(paramMeta);
            }
            int size = paramMetas.size();
            if (size == 0) continue;
            if (size == 1) {
                content.setSchema(this.schemaResolver.resolve((ParameterMeta)paramMetas.get(0)));
                continue;
            }
            content.setSchema(this.schemaResolver.resolve(paramMetas));
        }
    }

    private void resolveResponse(String httpStatusCode, ApiResponse response, OpenAPI openAPI, MethodMeta meta, RequestMapping mapping) {
        int httpStatus = Integer.parseInt(httpStatusCode);
        if (response.getDescription() == null) {
            response.setDescription(HttpUtils.getStatusMessage((int)httpStatus));
        }
        if (httpStatus > 201 && httpStatus < 400) {
            return;
        }
        if (meta.getActualReturnType() == Void.TYPE) {
            return;
        }
        Collection<Object> mediaTypes = null;
        if (mapping.getProducesCondition() != null) {
            mediaTypes = mapping.getProducesCondition().getMediaTypes();
        }
        if (mediaTypes == null) {
            String[] defaultMediaTypes = openAPI.getConfigValue(OpenAPIConfig::getDefaultProducesMediaTypes);
            mediaTypes = defaultMediaTypes == null ? Collections.singletonList(org.apache.dubbo.remoting.http12.message.MediaType.APPLICATION_JSON) : (Collection)Arrays.stream(defaultMediaTypes).map(org.apache.dubbo.remoting.http12.message.MediaType::of).collect(Collectors.toList());
        }
        for (org.apache.dubbo.remoting.http12.message.MediaType mediaType : mediaTypes) {
            MediaType content = response.getOrAddContent(mediaType.getName());
            if (content.getSchema() != null) continue;
            if (httpStatus >= 400) {
                content.setSchema(this.schemaResolver.resolve((Type)((Object)ErrorResponse.class)));
                continue;
            }
            content.setSchema(this.schemaResolver.resolve(meta.getReturnParameter()));
        }
    }

    private static final class OpenAPIChainImpl
    implements OpenAPIDefinitionResolver.OpenAPIChain {
        private final OpenAPIDefinitionResolver[] resolvers;
        private final Function<OpenAPI, OpenAPI> fallback;
        private int cursor;

        OpenAPIChainImpl(OpenAPIDefinitionResolver[] resolvers, Function<OpenAPI, OpenAPI> fallback) {
            this.resolvers = resolvers;
            this.fallback = fallback;
        }

        @Override
        public OpenAPI resolve(OpenAPI openAPI, ServiceMeta serviceMeta) {
            if (this.cursor < this.resolvers.length) {
                return this.resolvers[this.cursor++].resolve(openAPI, serviceMeta, this);
            }
            return this.fallback.apply(openAPI);
        }
    }

    private static final class OperationContextImpl
    extends AbstractContext
    implements OpenAPIDefinitionResolver.OperationContext {
        OperationContextImpl(OpenAPI openAPI, SchemaResolver schemaResolver, ExtensionFactory extensionFactory) {
            super(openAPI, schemaResolver, extensionFactory);
        }
    }

    private static final class OperationChainImpl
    implements OpenAPIDefinitionResolver.OperationChain {
        private final OpenAPIDefinitionResolver[] resolvers;
        private final Function<Operation, Operation> fallback;
        private int cursor;

        OperationChainImpl(OpenAPIDefinitionResolver[] resolvers, Function<Operation, Operation> fallback) {
            this.resolvers = resolvers;
            this.fallback = fallback;
        }

        @Override
        public Operation resolve(Operation operation, MethodMeta methodMeta, OpenAPIDefinitionResolver.OperationContext chain) {
            if (this.cursor < this.resolvers.length) {
                return this.resolvers[this.cursor++].resolve(operation, methodMeta, chain, this);
            }
            return this.fallback.apply(operation);
        }
    }
}

