/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi;

import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.rest.OpenAPIRequest;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.AbstractContext;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.ExtensionFactory;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.SchemaResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.OpenAPI;

final class ContextImpl
extends AbstractContext
implements Context {
    private final OpenAPIRequest request;
    private Boolean openAPI31;
    private Holder<HttpRequest> httpRequest;
    private Holder<HttpResponse> httpResponse;

    ContextImpl(OpenAPI openAPI, SchemaResolver schemaResolver, ExtensionFactory extFactory, OpenAPIRequest request) {
        super(openAPI, schemaResolver, extFactory);
        this.request = request;
    }

    @Override
    public boolean isOpenAPI31() {
        if (this.openAPI31 == null) {
            String v = this.request.getOpenapi();
            this.openAPI31 = v != null && v.startsWith("3.1.");
        }
        return this.openAPI31;
    }

    @Override
    public OpenAPIRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpRequest getHttpRequest() {
        Holder holder = this.httpRequest;
        if (holder == null) {
            holder = new Holder();
            holder.set((Object)((HttpRequest)RpcContext.getServiceContext().getRequest(HttpRequest.class)));
            this.httpRequest = holder;
        }
        return (HttpRequest)holder.get();
    }

    @Override
    public HttpResponse getHttpResponse() {
        Holder holder = this.httpResponse;
        if (holder == null) {
            holder = new Holder();
            holder.set((Object)((HttpResponse)RpcContext.getServiceContext().getResponse(HttpResponse.class)));
            this.httpResponse = holder;
        }
        return (HttpResponse)holder.get();
    }
}

