/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.redis.support;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.redis.RedisClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public abstract class AbstractRedisClient
implements RedisClient {
    private URL url;
    private JedisPoolConfig config;

    public AbstractRedisClient(URL url) {
        this.url = url;
        this.config = new JedisPoolConfig();
        this.config.setTestOnBorrow(url.getParameter("test.on.borrow", true));
        this.config.setTestOnReturn(url.getParameter("test.on.return", false));
        this.config.setTestWhileIdle(url.getParameter("test.while.idle", false));
        if (url.getParameter("max.idle", 0) > 0) {
            this.config.setMaxIdle(url.getParameter("max.idle", 0));
        }
        if (url.getParameter("min.idle", 0) > 0) {
            this.config.setMinIdle(url.getParameter("min.idle", 0));
        }
        if (url.getParameter("max.active", 0) > 0) {
            this.config.setMaxTotal(url.getParameter("max.active", 0));
        }
        if (url.getParameter("max.total", 0) > 0) {
            this.config.setMaxTotal(url.getParameter("max.total", 0));
        }
        if (url.getParameter("max.wait", url.getParameter("timeout", 0)) > 0) {
            this.config.setMaxWaitMillis((long)url.getParameter("max.wait", url.getParameter("timeout", 0)));
        }
        if (url.getParameter("num.tests.per.eviction.run", 0) > 0) {
            this.config.setNumTestsPerEvictionRun(url.getParameter("num.tests.per.eviction.run", 0));
        }
        if (url.getParameter("time.between.eviction.runs.millis", 0) > 0) {
            this.config.setTimeBetweenEvictionRunsMillis((long)url.getParameter("time.between.eviction.runs.millis", 0));
        }
        if (url.getParameter("min.evictable.idle.time.millis", 0) > 0) {
            this.config.setMinEvictableIdleTimeMillis((long)url.getParameter("min.evictable.idle.time.millis", 0));
        }
    }

    protected Set<String> scan(Jedis jedis, String pattern) {
        HashSet<String> result = new HashSet<String>();
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams params = new ScanParams();
        params.match(pattern);
        while (true) {
            ScanResult scanResult;
            List list;
            if (CollectionUtils.isNotEmpty((Collection)(list = (scanResult = jedis.scan(cursor, params)).getResult()))) {
                result.addAll(list);
            }
            if (ScanParams.SCAN_POINTER_START.equals(scanResult.getCursor())) break;
            cursor = scanResult.getCursor();
        }
        return result;
    }

    public URL getUrl() {
        return this.url;
    }

    public JedisPoolConfig getConfig() {
        return this.config;
    }
}

