/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4.http2;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;

public class Http2ClientSettingsHandler
extends SimpleChannelInboundHandler<Http2SettingsFrame> {
    private static final Logger logger = LoggerFactory.getLogger(Http2ClientSettingsHandler.class);
    private final AtomicReference<Promise<Void>> connectionPrefaceReceivedPromiseRef;

    public Http2ClientSettingsHandler(AtomicReference<Promise<Void>> connectionPrefaceReceivedPromiseRef) {
        this.connectionPrefaceReceivedPromiseRef = connectionPrefaceReceivedPromiseRef;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Http2SettingsFrame msg) throws Exception {
        Promise<Void> connectionPrefaceReceivedPromise;
        if (logger.isDebugEnabled()) {
            logger.debug("Receive server Http2 Settings frame of " + ctx.channel().localAddress() + " -> " + ctx.channel().remoteAddress());
        }
        if ((connectionPrefaceReceivedPromise = this.connectionPrefaceReceivedPromiseRef.get()) == null) {
            ctx.fireChannelRead((Object)msg);
        } else {
            connectionPrefaceReceivedPromise.trySuccess(null);
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }
}

