/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.api.pu.AbstractPortUnificationServer;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelHandlers;
import org.apache.dubbo.remoting.transport.netty4.NettyChannelHandler;
import org.apache.dubbo.remoting.transport.netty4.NettyEventLoopFactory;
import org.apache.dubbo.remoting.transport.netty4.NettyPortUnificationServerHandler;
import org.apache.dubbo.rpc.model.ScopeModel;

public class NettyPortUnificationServer
extends AbstractPortUnificationServer {
    private int serverShutdownTimeoutMills;
    private ServerBootstrap bootstrap;
    private io.netty.channel.Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Map<String, Channel> dubboChannels;

    public NettyPortUnificationServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, ChannelHandlers.wrap((ChannelHandler)handler, (URL)url));
    }

    public void addSupportedProtocol(URL url, ChannelHandler handler) {
        super.addSupportedProtocol(url, ChannelHandlers.wrap((ChannelHandler)handler, (URL)url));
    }

    public void close() {
        if (this.channel != null) {
            this.doClose();
        }
    }

    public void bind() throws Throwable {
        if (this.channel == null) {
            this.doOpen();
        }
    }

    public void doOpen0() {
        this.bootstrap = new ServerBootstrap();
        this.dubboChannels = new ConcurrentHashMap<String, Channel>();
        this.serverShutdownTimeoutMills = ConfigurationUtils.getServerShutdownTimeout((ScopeModel)this.getUrl().getOrDefaultModuleModel());
        this.bossGroup = NettyEventLoopFactory.eventLoopGroup(1, "NettyServerBoss");
        this.workerGroup = NettyEventLoopFactory.eventLoopGroup(this.getUrl().getPositiveParameter("iothreads", Constants.DEFAULT_IO_THREADS), "NettyServerWorker");
        ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NettyEventLoopFactory.serverSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE)).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childHandler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                NettyChannelHandler nettyChannelHandler = new NettyChannelHandler(NettyPortUnificationServer.this.dubboChannels, NettyPortUnificationServer.this.getUrl(), (ChannelHandler)NettyPortUnificationServer.this);
                NettyPortUnificationServerHandler puHandler = new NettyPortUnificationServerHandler(NettyPortUnificationServer.this.getUrl(), true, NettyPortUnificationServer.this.getProtocols(), (ChannelHandler)NettyPortUnificationServer.this, NettyPortUnificationServer.this.getSupportedUrls(), NettyPortUnificationServer.this.getSupportedHandlers());
                p.addLast("channel-handler", (io.netty.channel.ChannelHandler)nettyChannelHandler);
                p.addLast("negotiation-protocol", (io.netty.channel.ChannelHandler)puHandler);
            }
        });
        String bindIp = this.getUrl().getParameter("bind.ip", this.getUrl().getHost());
        int bindPort = this.getUrl().getParameter("bind.port", this.getUrl().getPort());
        if (this.getUrl().getParameter("anyhost", false) || NetUtils.isInvalidLocalHost((String)bindIp)) {
            bindIp = "0.0.0.0";
        }
        InetSocketAddress bindAddress = new InetSocketAddress(bindIp, bindPort);
        try {
            ChannelFuture channelFuture = this.bootstrap.bind((SocketAddress)bindAddress);
            channelFuture.syncUninterruptibly();
            this.channel = channelFuture.channel();
        }
        catch (Throwable t) {
            this.closeBootstrap();
            throw t;
        }
    }

    private void closeBootstrap() {
        try {
            if (this.bootstrap != null) {
                long timeout = ConfigurationUtils.reCalShutdownTime((int)this.serverShutdownTimeoutMills);
                long quietPeriod = Math.min(2000L, timeout);
                Future bossGroupShutdownFuture = this.bossGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                Future workerGroupShutdownFuture = this.workerGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS);
                bossGroupShutdownFuture.awaitUninterruptibly(timeout, TimeUnit.MILLISECONDS);
                workerGroupShutdownFuture.awaitUninterruptibly(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", e.getMessage(), e);
        }
    }

    public void doClose() {
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", "Interrupted while shutting down", e);
        }
        try {
            Collection<Channel> channels = this.getChannels();
            if (CollectionUtils.isNotEmpty(channels)) {
                for (Channel channel : channels) {
                    try {
                        channel.close();
                    }
                    catch (Throwable e) {
                        this.logger.warn("6-3", "", "", e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.warn("6-3", "", "", e.getMessage(), e);
        }
        for (WireProtocol protocol : this.getProtocols().values()) {
            protocol.close();
        }
        this.closeBootstrap();
    }

    protected int getChannelsSize() {
        return this.dubboChannels.size();
    }

    public boolean isBound() {
        return this.channel.isActive();
    }

    public Collection<Channel> getChannels() {
        ArrayList<Channel> chs = new ArrayList<Channel>(this.dubboChannels.size());
        chs.addAll(this.dubboChannels.values());
        return chs;
    }

    public Channel getChannel(InetSocketAddress remoteAddress) {
        return this.dubboChannels.get(NetUtils.toAddressString((InetSocketAddress)remoteAddress));
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public boolean canHandleIdle() {
        return true;
    }
}

