/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.api.pu.ChannelOperator;
import org.apache.dubbo.remoting.api.ssl.ContextOperator;
import org.apache.dubbo.remoting.transport.netty4.AbstractNettyConnectionClient;
import org.apache.dubbo.remoting.transport.netty4.NettyChannel;
import org.apache.dubbo.remoting.transport.netty4.NettyConfigOperator;
import org.apache.dubbo.remoting.transport.netty4.NettyConnectionHandler;
import org.apache.dubbo.remoting.transport.netty4.NettyEventLoopFactory;
import org.apache.dubbo.remoting.transport.netty4.NettySslContextOperator;
import org.apache.dubbo.remoting.transport.netty4.http2.Http2ClientSettingsHandler;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslClientTlsHandler;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslContexts;
import org.apache.dubbo.remoting.utils.UrlUtils;

public final class NettyConnectionClient
extends AbstractNettyConnectionClient {
    private Bootstrap bootstrap;
    private AtomicReference<Promise<Void>> channelInitializedPromiseRef;
    private AtomicReference<Promise<Void>> connectionPrefaceReceivedPromiseRef;

    public NettyConnectionClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    @Override
    protected void initConnectionClient() {
        this.protocol = (WireProtocol)this.getUrl().getOrDefaultFrameworkModel().getExtensionLoader(WireProtocol.class).getExtension(this.getUrl().getProtocol());
        super.initConnectionClient();
    }

    @Override
    protected void initBootstrap() {
        this.channelInitializedPromiseRef = new AtomicReference();
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)NettyEventLoopFactory.NIO_EVENT_LOOP_GROUP.get())).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).remoteAddress((SocketAddress)this.getConnectAddress()).channel(NettyEventLoopFactory.socketChannelClass());
        final NettyConnectionHandler connectionHandler = new NettyConnectionHandler(this);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.getConnectTimeout());
        final SslContext sslContext = SslContexts.buildClientSslContext(this.getUrl());
        bootstrap.handler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                NettyChannel nettyChannel = NettyChannel.getOrAddChannel((io.netty.channel.Channel)ch, NettyConnectionClient.this.getUrl(), NettyConnectionClient.this.getChannelHandler());
                ChannelPipeline pipeline = ch.pipeline();
                NettySslContextOperator nettySslContextOperator = new NettySslContextOperator();
                if (sslContext != null) {
                    pipeline.addLast("negotiation", (io.netty.channel.ChannelHandler)new SslClientTlsHandler(sslContext));
                }
                int heartbeat = UrlUtils.getHeartbeat((URL)NettyConnectionClient.this.getUrl());
                pipeline.addLast("client-idle-handler", (io.netty.channel.ChannelHandler)new IdleStateHandler((long)heartbeat, 0L, 0L, TimeUnit.MILLISECONDS));
                pipeline.addLast("connectionHandler", (io.netty.channel.ChannelHandler)connectionHandler);
                NettyConfigOperator operator = new NettyConfigOperator(nettyChannel, NettyConnectionClient.this.getChannelHandler());
                NettyConnectionClient.this.protocol.configClientPipeline(NettyConnectionClient.this.getUrl(), (ChannelOperator)operator, (ContextOperator)nettySslContextOperator);
                ChannelHandlerContext http2FrameCodecHandlerCtx = pipeline.context(Http2FrameCodec.class);
                if (http2FrameCodecHandlerCtx == null) {
                    NettyConnectionClient.this.connectionPrefaceReceivedPromiseRef = null;
                } else {
                    if (NettyConnectionClient.this.connectionPrefaceReceivedPromiseRef == null) {
                        NettyConnectionClient.this.connectionPrefaceReceivedPromiseRef = new AtomicReference();
                    }
                    NettyConnectionClient.this.connectionPrefaceReceivedPromiseRef.compareAndSet(null, new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE));
                    pipeline.addAfter(http2FrameCodecHandlerCtx.name(), "client-connection-preface-handler", (io.netty.channel.ChannelHandler)new Http2ClientSettingsHandler(NettyConnectionClient.this.connectionPrefaceReceivedPromiseRef));
                }
                ch.closeFuture().addListener(channelFuture -> NettyConnectionClient.this.clearNettyChannel());
                Promise channelInitializedPromise = (Promise)NettyConnectionClient.this.channelInitializedPromiseRef.get();
                if (channelInitializedPromise != null) {
                    channelInitializedPromise.trySuccess(null);
                }
            }
        });
        this.bootstrap = bootstrap;
    }

    @Override
    protected ChannelFuture performConnect() {
        return this.bootstrap.connect();
    }

    @Override
    protected void doConnect() throws RemotingException {
        long start = System.currentTimeMillis();
        this.channelInitializedPromiseRef.compareAndSet(null, (Promise<Void>)new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE));
        super.doConnect();
        this.waitConnectionPreface(start);
    }

    private void waitConnectionPreface(long start) throws RemotingException {
        Promise<Void> channelInitializedPromise = this.channelInitializedPromiseRef.get();
        long retainedTimeout = (long)this.getConnectTimeout() - System.currentTimeMillis() + start;
        boolean ret = channelInitializedPromise.awaitUninterruptibly(retainedTimeout, TimeUnit.MILLISECONDS);
        this.channelInitializedPromiseRef.set(null);
        if (!ret || !channelInitializedPromise.isSuccess()) {
            RemotingException remotingException = new RemotingException((Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getConnectAddress() + " client-side channel initialization timeout " + this.getConnectTimeout() + "ms (elapsed: " + (System.currentTimeMillis() - start) + "ms) from netty client " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion());
            this.logger.error("6-2", "provider crash", "", "Client-side channel initialization timeout", (Throwable)remotingException);
            throw remotingException;
        }
        if (this.connectionPrefaceReceivedPromiseRef == null) {
            return;
        }
        Promise<Void> connectionPrefaceReceivedPromise = this.connectionPrefaceReceivedPromiseRef.get();
        retainedTimeout = (long)this.getConnectTimeout() - System.currentTimeMillis() + start;
        ret = connectionPrefaceReceivedPromise.awaitUninterruptibly(retainedTimeout, TimeUnit.MILLISECONDS);
        this.connectionPrefaceReceivedPromiseRef.set(null);
        if (!ret || !connectionPrefaceReceivedPromise.isSuccess()) {
            RemotingException remotingException = new RemotingException((Channel)this, "client(url: " + this.getUrl() + ") failed to connect to server " + this.getConnectAddress() + " client-side connection preface timeout " + this.getConnectTimeout() + "ms (elapsed: " + (System.currentTimeMillis() - start) + "ms) from netty client " + NetUtils.getLocalHost() + " using dubbo version " + Version.getVersion());
            this.logger.error("6-2", "provider crash", "", "Client-side connection preface timeout", (Throwable)remotingException);
            throw remotingException;
        }
    }
}

