/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4.ssl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.AttributeKey;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.transport.netty4.ssl.SslContexts;

public class SslClientTlsHandler
extends ChannelInboundHandlerAdapter {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SslClientTlsHandler.class);
    private static final AttributeKey<SSLSession> SSL_SESSION_KEY = AttributeKey.valueOf((String)"ssl-session");
    private final SslContext sslContext;

    public SslClientTlsHandler(URL url) {
        this(SslContexts.buildClientSslContext(url));
    }

    public SslClientTlsHandler(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        SSLEngine sslEngine = this.sslContext.newEngine(ctx.alloc());
        ctx.pipeline().addAfter(ctx.name(), null, (ChannelHandler)new SslHandler(sslEngine, false));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
            if (handshakeEvent.isSuccess()) {
                SSLSession session = ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession();
                logger.info("TLS negotiation succeed with: " + session.getPeerHost());
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.channel().attr(SSL_SESSION_KEY).set((Object)session);
            } else {
                logger.error("99-0", "unknown error in remoting module", "", "TLS negotiation failed when trying to accept new connection.", handshakeEvent.cause());
                ctx.fireExceptionCaught(handshakeEvent.cause());
            }
        }
    }
}

